/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.kintone.client.AppIconDeserializer;
import com.kintone.client.CustomizeResourceDeserializer;
import com.kintone.client.EveryMonthPeriodSerializer;
import com.kintone.client.EveryQuarterPeriodSerializer;
import com.kintone.client.FieldPropertyDeserializer;
import com.kintone.client.LayoutDeserializer;
import com.kintone.client.PeriodicReportPeriodDeserializer;
import com.kintone.client.RecordDeserializer;
import com.kintone.client.RecordSerializer;
import com.kintone.client.exception.KintoneRuntimeException;
import com.kintone.client.model.app.AppIcon;
import com.kintone.client.model.app.CustomizeResource;
import com.kintone.client.model.app.field.FieldProperty;
import com.kintone.client.model.app.layout.Layout;
import com.kintone.client.model.app.report.EveryMonthPeriod;
import com.kintone.client.model.app.report.EveryQuarterPeriod;
import com.kintone.client.model.app.report.PeriodicReportPeriod;
import com.kintone.client.model.record.Record;
import java.io.IOException;
import java.io.InputStream;

class JsonMapper {
    private final ObjectMapper mapper = JsonMapper.createObjectMapper();

    JsonMapper() {
    }

    private static ObjectMapper createObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Record.class, (JsonDeserializer)new RecordDeserializer());
        module.addDeserializer(FieldProperty.class, (JsonDeserializer)new FieldPropertyDeserializer());
        module.addDeserializer(Layout.class, (JsonDeserializer)new LayoutDeserializer());
        module.addDeserializer(CustomizeResource.class, (JsonDeserializer)new CustomizeResourceDeserializer());
        module.addDeserializer(AppIcon.class, (JsonDeserializer)new AppIconDeserializer());
        module.addDeserializer(PeriodicReportPeriod.class, (JsonDeserializer)new PeriodicReportPeriodDeserializer());
        module.addSerializer(Record.class, (JsonSerializer)new RecordSerializer());
        module.addSerializer(EveryMonthPeriod.class, (JsonSerializer)new EveryMonthPeriodSerializer());
        module.addSerializer(EveryQuarterPeriod.class, (JsonSerializer)new EveryQuarterPeriodSerializer());
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)com.fasterxml.jackson.databind.json.JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).addModule((Module)module)).addModule((Module)new JavaTimeModule())).build();
    }

    byte[] format(Object obj) {
        try {
            return this.mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new KintoneRuntimeException("Failed to format request JSON", e);
        }
    }

    <T> T parse(InputStream stream, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(stream, clazz);
        }
        catch (IOException e) {
            throw new KintoneRuntimeException("Failed to parse response JSON", e);
        }
    }

    <T> T convert(Object object, Class<T> clazz) {
        return (T)this.mapper.convertValue(object, clazz);
    }
}

