/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.kintone.client.AppClient;
import com.kintone.client.FileClient;
import com.kintone.client.InternalClient;
import com.kintone.client.RecordClient;
import com.kintone.client.ResponseHandler;
import com.kintone.client.SchemaClient;
import com.kintone.client.SpaceClient;
import com.kintone.client.api.KintoneResponse;
import com.kintone.client.api.common.BulkRequestsRequest;
import com.kintone.client.api.common.BulkRequestsResponseBody;
import com.kintone.client.exception.KintoneApiRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class KintoneClient
implements AutoCloseable {
    private final InternalClient client;
    private final AppClient appClient;
    private final RecordClient recordClient;
    private final SpaceClient spaceClient;
    private final FileClient fileClient;
    private final SchemaClient schemaClient;
    private final List<ResponseHandler> handlers = new ArrayList<ResponseHandler>();

    KintoneClient(InternalClient client) {
        this.handlers.add(new DefaultErrorHandler());
        this.client = client;
        this.appClient = new AppClient(client, this.handlers);
        this.recordClient = new RecordClient(client, this.handlers);
        this.spaceClient = new SpaceClient(client, this.handlers);
        this.fileClient = new FileClient(client, this.handlers);
        this.schemaClient = new SchemaClient(client, this.handlers);
    }

    public AppClient app() {
        return this.appClient;
    }

    public RecordClient record() {
        return this.recordClient;
    }

    public SpaceClient space() {
        return this.spaceClient;
    }

    public FileClient file() {
        return this.fileClient;
    }

    public SchemaClient schema() {
        return this.schemaClient;
    }

    public BulkRequestsResponseBody bulkRequests(BulkRequestsRequest request) {
        return this.client.bulkRequest(request, this.handlers);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static class DefaultErrorHandler
    implements ResponseHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void handle(KintoneResponse<?> response) {
            if (!this.isSuccess(response.getStatusCode())) {
                throw new KintoneApiRuntimeException(response.getStatusCode(), response.getHeaders(), response.getErrorBody());
            }
        }

        private boolean isSuccess(int statusCode) {
            return 200 <= statusCode && statusCode < 300;
        }
    }
}

