/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.kintone.client.InternalClientImpl;
import com.kintone.client.KintoneClient;
import com.kintone.client.exception.KintoneRuntimeException;
import com.kintone.client.model.Auth;
import com.kintone.client.model.BasicAuth;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.ssl.SSLContexts;

public class KintoneClientBuilder {
    private static final int DEFAULT_TIMEOUT = 60000;
    private String baseUrl;
    private Auth auth;
    private URI proxyHost;
    private BasicAuth proxyAuth;
    private SSLContext sslContext;
    private int connectionTimeout = 60000;
    private int socketTimeout = 60000;
    private int connectionRequestTimeout = 60000;
    private BasicAuth basicAuth;
    private Long guestSpaceId;
    private String appendixUserAgent;

    private KintoneClientBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public static KintoneClientBuilder create(String baseUrl) {
        return new KintoneClientBuilder(baseUrl);
    }

    public static KintoneClient defaultClient(String baseUrl, String user, String password) {
        return new KintoneClientBuilder(baseUrl).authByPassword(user, password).build();
    }

    public static KintoneClient defaultClient(String baseUrl, String apiToken) {
        return new KintoneClientBuilder(baseUrl).authByApiToken(apiToken).build();
    }

    public static KintoneClient defaultClient(String baseUrl, List<String> apiTokens) {
        return new KintoneClientBuilder(baseUrl).authByApiToken(apiTokens).build();
    }

    public KintoneClientBuilder withBasicAuth(String user, String password) {
        this.basicAuth = new BasicAuth(user, password);
        return this;
    }

    public KintoneClientBuilder authByPassword(String user, String password) {
        this.auth = Auth.byPassword(user, password);
        return this;
    }

    public KintoneClientBuilder authByApiToken(String apiToken) {
        this.auth = Auth.byApiToken(apiToken);
        return this;
    }

    public KintoneClientBuilder authByApiToken(Collection<String> apiTokens) {
        this.auth = Auth.byApiToken(new ArrayList<String>(apiTokens));
        return this;
    }

    public KintoneClientBuilder withProxy(String scheme, String hostname, int port) {
        try {
            this.proxyHost = new URIBuilder().setScheme(scheme).setHost(hostname).setPort(port).build();
        }
        catch (URISyntaxException e) {
            throw new KintoneRuntimeException("Failed to create uri object.", e);
        }
        return this;
    }

    public KintoneClientBuilder setProxyAuthentication(String user, String password) {
        this.proxyAuth = new BasicAuth(user, password);
        return this;
    }

    public KintoneClientBuilder withClientCertificate(Path certificate, String password) {
        try {
            return this.withClientCertificate(Files.newInputStream(certificate, new OpenOption[0]), password);
        }
        catch (IOException e) {
            throw new KintoneRuntimeException("Failed to create ssl context.", e);
        }
    }

    public KintoneClientBuilder withClientCertificate(InputStream stream, String password) {
        this.sslContext = this.createSSLContext(stream, password);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLContext createSSLContext(InputStream stream, String password) {
        char[] pass = password.toCharArray();
        try (InputStream stream0 = stream;){
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(stream0, pass);
            SSLContext sSLContext = SSLContexts.custom().loadKeyMaterial(keyStore, pass).build();
            return sSLContext;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KintoneRuntimeException("Failed to create ssl context.", e);
        }
    }

    public KintoneClientBuilder setGuestSpaceId(long guestSpaceId) {
        this.guestSpaceId = guestSpaceId;
        return this;
    }

    public KintoneClientBuilder setAppendixUserAgent(String appendixUserAgent) {
        this.appendixUserAgent = appendixUserAgent;
        return this;
    }

    public KintoneClientBuilder setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public KintoneClientBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public KintoneClientBuilder setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public KintoneClient build() {
        InternalClientImpl client = new InternalClientImpl(this.baseUrl, this.auth, this.basicAuth, this.proxyHost, this.proxyAuth, this.sslContext, this.guestSpaceId, this.appendixUserAgent, this.connectionTimeout, this.socketTimeout, this.connectionRequestTimeout);
        return new KintoneClient(client);
    }
}

