/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.kintone.client.exception.KintoneRuntimeException;
import com.kintone.client.model.app.layout.GroupLayout;
import com.kintone.client.model.app.layout.Layout;
import com.kintone.client.model.app.layout.RowLayout;
import com.kintone.client.model.app.layout.SubtableLayout;
import java.io.IOException;

class LayoutDeserializer
extends StdDeserializer<Layout> {
    private static final long serialVersionUID = 7393979541628669470L;

    LayoutDeserializer() {
        this(null);
    }

    LayoutDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public Layout deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String type;
        ObjectCodec codec = p.getCodec();
        JsonNode node = (JsonNode)codec.readTree(p);
        switch (type = node.get("type").textValue()) {
            case "ROW": {
                return (Layout)codec.treeToValue((TreeNode)node, RowLayout.class);
            }
            case "SUBTABLE": {
                return (Layout)codec.treeToValue((TreeNode)node, SubtableLayout.class);
            }
            case "GROUP": {
                return (Layout)codec.treeToValue((TreeNode)node, GroupLayout.class);
            }
        }
        throw new KintoneRuntimeException("Invalid layout type: " + type);
    }
}

