/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.kintone.client.exception.KintoneRuntimeException;
import com.kintone.client.model.app.report.EveryMonthPeriod;
import com.kintone.client.model.app.report.EveryQuarterPeriod;
import com.kintone.client.model.app.report.IntervalType;
import com.kintone.client.model.app.report.PeriodicReportPeriod;
import com.kintone.client.model.app.report.QuarterlyPattern;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

class PeriodicReportPeriodDeserializer
extends StdDeserializer<PeriodicReportPeriod> {
    private static final long serialVersionUID = 7683119889317941808L;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");

    PeriodicReportPeriodDeserializer() {
        this(null);
    }

    PeriodicReportPeriodDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public PeriodicReportPeriod deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        IntervalType intervalType;
        ObjectCodec codec = p.getCodec();
        JsonNode node = (JsonNode)codec.readTree(p);
        String type = node.get("every").textValue();
        try {
            intervalType = IntervalType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new KintoneRuntimeException("Invalid interval type: " + type);
        }
        if (intervalType.getPropertyClass() == null) {
            throw new KintoneRuntimeException("Invalid interval type: " + type);
        }
        if (intervalType == IntervalType.MONTH) {
            return this.deserializeEveryMonthPeriod(node);
        }
        if (intervalType == IntervalType.QUARTER) {
            return this.deserializeEveryQuarterPeriod(node);
        }
        return (PeriodicReportPeriod)codec.treeToValue((TreeNode)node, intervalType.getPropertyClass());
    }

    private EveryMonthPeriod deserializeEveryMonthPeriod(JsonNode node) {
        EveryMonthPeriod period = new EveryMonthPeriod();
        String dayOfMonth = node.get("dayOfMonth").textValue();
        if ("END_OF_MONTH".equals(dayOfMonth)) {
            period.setEndOfMonth();
        } else if (dayOfMonth != null) {
            period.setDayOfMonth(Integer.valueOf(dayOfMonth));
        }
        String time = node.get("time").textValue();
        if (time != null) {
            period.setTime(LocalTime.parse(time, TIME_FORMATTER));
        }
        return period;
    }

    private EveryQuarterPeriod deserializeEveryQuarterPeriod(JsonNode node) {
        String dayOfMonth;
        EveryQuarterPeriod period = new EveryQuarterPeriod();
        String pattern = node.get("pattern").textValue();
        if (pattern != null) {
            period.setPattern(QuarterlyPattern.valueOf(pattern));
        }
        if ("END_OF_MONTH".equals(dayOfMonth = node.get("dayOfMonth").textValue())) {
            period.setEndOfMonth();
        } else if (dayOfMonth != null) {
            period.setDayOfMonth(Integer.valueOf(dayOfMonth));
        }
        String time = node.get("time").textValue();
        if (time != null) {
            period.setTime(LocalTime.parse(time, TIME_FORMATTER));
        }
        return period;
    }
}

