/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.kintone.client.InternalClient;
import com.kintone.client.KintoneApi;
import com.kintone.client.ResponseHandler;
import com.kintone.client.api.record.AddRecordCommentRequest;
import com.kintone.client.api.record.AddRecordCommentResponseBody;
import com.kintone.client.api.record.AddRecordRequest;
import com.kintone.client.api.record.AddRecordResponseBody;
import com.kintone.client.api.record.AddRecordsRequest;
import com.kintone.client.api.record.AddRecordsResponseBody;
import com.kintone.client.api.record.CreateCursorRequest;
import com.kintone.client.api.record.CreateCursorResponseBody;
import com.kintone.client.api.record.DeleteCursorRequest;
import com.kintone.client.api.record.DeleteCursorResponseBody;
import com.kintone.client.api.record.DeleteRecordCommentRequest;
import com.kintone.client.api.record.DeleteRecordCommentResponseBody;
import com.kintone.client.api.record.DeleteRecordsRequest;
import com.kintone.client.api.record.DeleteRecordsResponseBody;
import com.kintone.client.api.record.GetRecordCommentsRequest;
import com.kintone.client.api.record.GetRecordCommentsResponseBody;
import com.kintone.client.api.record.GetRecordRequest;
import com.kintone.client.api.record.GetRecordResponseBody;
import com.kintone.client.api.record.GetRecordsByCursorRequest;
import com.kintone.client.api.record.GetRecordsByCursorResponseBody;
import com.kintone.client.api.record.GetRecordsRequest;
import com.kintone.client.api.record.GetRecordsResponseBody;
import com.kintone.client.api.record.UpdateRecordAssigneesRequest;
import com.kintone.client.api.record.UpdateRecordAssigneesResponseBody;
import com.kintone.client.api.record.UpdateRecordRequest;
import com.kintone.client.api.record.UpdateRecordResponseBody;
import com.kintone.client.api.record.UpdateRecordStatusRequest;
import com.kintone.client.api.record.UpdateRecordStatusResponseBody;
import com.kintone.client.api.record.UpdateRecordStatusesRequest;
import com.kintone.client.api.record.UpdateRecordStatusesResponseBody;
import com.kintone.client.api.record.UpdateRecordsRequest;
import com.kintone.client.api.record.UpdateRecordsResponseBody;
import com.kintone.client.model.Order;
import com.kintone.client.model.record.PostedRecordComment;
import com.kintone.client.model.record.Record;
import com.kintone.client.model.record.RecordComment;
import com.kintone.client.model.record.RecordForUpdate;
import com.kintone.client.model.record.RecordRevision;
import com.kintone.client.model.record.StatusAction;
import com.kintone.client.model.record.UpdateKey;
import java.beans.ConstructorProperties;
import java.util.List;

public class RecordClient {
    private static final long MAX_OFFSET = 10000L;
    private final InternalClient client;
    private final List<ResponseHandler> handlers;

    public long addRecord(long app, Record record) {
        AddRecordRequest req = new AddRecordRequest();
        req.setApp(app);
        req.setRecord(record);
        return this.addRecord(req).getId();
    }

    public AddRecordResponseBody addRecord(AddRecordRequest request) {
        return (AddRecordResponseBody)this.client.call(KintoneApi.ADD_RECORD, request, this.handlers);
    }

    public long addRecordComment(long app, long recordId, RecordComment comment) {
        AddRecordCommentRequest req = new AddRecordCommentRequest();
        req.setApp(app);
        req.setRecord(recordId);
        req.setComment(comment);
        return this.addRecordComment(req).getId();
    }

    public AddRecordCommentResponseBody addRecordComment(AddRecordCommentRequest request) {
        return (AddRecordCommentResponseBody)this.client.call(KintoneApi.ADD_RECORD_COMMENT, request, this.handlers);
    }

    public List<Long> addRecords(long app, List<Record> records) {
        AddRecordsRequest req = new AddRecordsRequest();
        req.setApp(app);
        req.setRecords(records);
        return this.addRecords(req).getIds();
    }

    public AddRecordsResponseBody addRecords(AddRecordsRequest request) {
        return (AddRecordsResponseBody)this.client.call(KintoneApi.ADD_RECORDS, request, this.handlers);
    }

    public long countRecords(long app) {
        return this.countRecords(app, null);
    }

    public long countRecords(long app, String query) {
        GetRecordsRequest req = new GetRecordsRequest();
        req.setApp(app);
        req.setQuery(query);
        req.setTotalCount(true);
        return this.getRecords(req).getTotalCount();
    }

    public String createCursor(long app) {
        return this.createCursor(app, null, null);
    }

    public String createCursor(long app, List<String> fields, String query) {
        CreateCursorRequest req = new CreateCursorRequest();
        req.setApp(app);
        req.setFields(fields);
        req.setQuery(query);
        return this.createCursor(req).getId();
    }

    public CreateCursorResponseBody createCursor(CreateCursorRequest request) {
        return (CreateCursorResponseBody)this.client.call(KintoneApi.CREATE_CURSOR, request, this.handlers);
    }

    public void deleteCursor(String id) {
        DeleteCursorRequest req = new DeleteCursorRequest();
        req.setId(id);
        this.deleteCursor(req);
    }

    public DeleteCursorResponseBody deleteCursor(DeleteCursorRequest request) {
        return (DeleteCursorResponseBody)this.client.call(KintoneApi.DELETE_CURSOR, request, this.handlers);
    }

    public void deleteRecordComment(long app, long recordId, long commentId) {
        DeleteRecordCommentRequest req = new DeleteRecordCommentRequest();
        req.setApp(app);
        req.setRecord(recordId);
        req.setComment(commentId);
        this.deleteRecordComment(req);
    }

    public DeleteRecordCommentResponseBody deleteRecordComment(DeleteRecordCommentRequest request) {
        return (DeleteRecordCommentResponseBody)this.client.call(KintoneApi.DELETE_RECORD_COMMENT, request, this.handlers);
    }

    public void deleteRecords(long app, List<Long> recordIds) {
        this.deleteRecords(app, recordIds, null);
    }

    public void deleteRecords(long app, List<Long> recordIds, List<Long> revisions) {
        DeleteRecordsRequest req = new DeleteRecordsRequest();
        req.setApp(app);
        req.setIds(recordIds);
        req.setRevisions(revisions);
        this.deleteRecords(req);
    }

    public DeleteRecordsResponseBody deleteRecords(DeleteRecordsRequest request) {
        return (DeleteRecordsResponseBody)this.client.call(KintoneApi.DELETE_RECORDS, request, this.handlers);
    }

    public Record getRecord(long app, long recordId) {
        GetRecordRequest req = new GetRecordRequest();
        req.setApp(app);
        req.setId(recordId);
        return this.getRecord(req).getRecord();
    }

    public GetRecordResponseBody getRecord(GetRecordRequest request) {
        return (GetRecordResponseBody)this.client.call(KintoneApi.GET_RECORD, request, this.handlers);
    }

    public List<PostedRecordComment> getRecordComments(long app, long recordId) {
        return this.getRecordComments(app, recordId, null, null, null);
    }

    public List<PostedRecordComment> getRecordComments(long app, long recordId, Order order, Long offset, Long limit) {
        GetRecordCommentsRequest req = new GetRecordCommentsRequest();
        req.setApp(app);
        req.setRecord(recordId);
        req.setOrder(order);
        req.setOffset(offset);
        req.setLimit(limit);
        return this.getRecordComments(req).getComments();
    }

    public GetRecordCommentsResponseBody getRecordComments(GetRecordCommentsRequest request) {
        return (GetRecordCommentsResponseBody)this.client.call(KintoneApi.GET_RECORD_COMMENTS, request, this.handlers);
    }

    public List<Record> getRecords(long app) {
        return this.getRecords(app, null, null);
    }

    public List<Record> getRecords(long app, int limit, long offset) {
        return this.getRecords(app, null, limit, offset);
    }

    public List<Record> getRecords(long app, List<String> fields, int limit, long offset) {
        if (offset > 10000L) {
            throw new IllegalArgumentException("The offset parameter is too large. Use the cursor API instead.");
        }
        return this.getRecords(app, fields, "limit " + limit + " offset " + offset);
    }

    public List<Record> getRecords(long app, String query) {
        return this.getRecords(app, null, query);
    }

    public List<Record> getRecords(long app, List<String> fields, String query) {
        GetRecordsRequest req = new GetRecordsRequest();
        req.setApp(app);
        req.setFields(fields);
        req.setQuery(query);
        req.setTotalCount(false);
        return this.getRecords(req).getRecords();
    }

    public GetRecordsResponseBody getRecords(GetRecordsRequest request) {
        return (GetRecordsResponseBody)this.client.call(KintoneApi.GET_RECORDS, request, this.handlers);
    }

    public GetRecordsByCursorResponseBody getRecordsByCursor(String id) {
        GetRecordsByCursorRequest req = new GetRecordsByCursorRequest();
        req.setId(id);
        return this.getRecordsByCursor(req);
    }

    public GetRecordsByCursorResponseBody getRecordsByCursor(GetRecordsByCursorRequest request) {
        return (GetRecordsByCursorResponseBody)this.client.call(KintoneApi.GET_RECORDS_BY_CURSOR, request, this.handlers);
    }

    public long updateRecord(long app, long recordId, Record record) {
        UpdateRecordRequest req = new UpdateRecordRequest();
        req.setApp(app);
        req.setId(recordId);
        req.setRecord(record);
        return this.updateRecord(req).getRevision();
    }

    public long updateRecord(long app, UpdateKey updateKey, Record record) {
        UpdateRecordRequest req = new UpdateRecordRequest();
        req.setApp(app);
        req.setRecord(record);
        req.setUpdateKey(updateKey);
        return this.updateRecord(req).getRevision();
    }

    public UpdateRecordResponseBody updateRecord(UpdateRecordRequest request) {
        return (UpdateRecordResponseBody)this.client.call(KintoneApi.UPDATE_RECORD, request, this.handlers);
    }

    public long updateRecordAssignees(long app, long recordId, List<String> assignees) {
        UpdateRecordAssigneesRequest req = new UpdateRecordAssigneesRequest();
        req.setApp(app);
        req.setId(recordId);
        req.setAssignees(assignees);
        return this.updateRecordAssignees(req).getRevision();
    }

    public UpdateRecordAssigneesResponseBody updateRecordAssignees(UpdateRecordAssigneesRequest request) {
        return (UpdateRecordAssigneesResponseBody)this.client.call(KintoneApi.UPDATE_RECORD_ASSIGNEES, request, this.handlers);
    }

    public List<RecordRevision> updateRecords(long app, List<RecordForUpdate> records) {
        UpdateRecordsRequest req = new UpdateRecordsRequest();
        req.setApp(app);
        req.setRecords(records);
        return this.updateRecords(req).getRecords();
    }

    public UpdateRecordsResponseBody updateRecords(UpdateRecordsRequest request) {
        return (UpdateRecordsResponseBody)this.client.call(KintoneApi.UPDATE_RECORDS, request, this.handlers);
    }

    public long updateRecordStatus(long app, long recordId, String action) {
        return this.updateRecordStatus(app, recordId, action, null);
    }

    public long updateRecordStatus(long app, long recordId, String action, String assignee) {
        UpdateRecordStatusRequest req = new UpdateRecordStatusRequest();
        req.setApp(app);
        req.setId(recordId);
        req.setAction(action);
        req.setAssignee(assignee);
        return this.updateRecordStatus(req).getRevision();
    }

    public UpdateRecordStatusResponseBody updateRecordStatus(UpdateRecordStatusRequest request) {
        return (UpdateRecordStatusResponseBody)this.client.call(KintoneApi.UPDATE_RECORD_STATUS, request, this.handlers);
    }

    public List<RecordRevision> updateRecordStatuses(long app, List<StatusAction> statusActions) {
        UpdateRecordStatusesRequest req = new UpdateRecordStatusesRequest();
        req.setApp(app);
        req.setRecords(statusActions);
        return this.updateRecordStatuses(req).getRecords();
    }

    public UpdateRecordStatusesResponseBody updateRecordStatuses(UpdateRecordStatusesRequest request) {
        return (UpdateRecordStatusesResponseBody)this.client.call(KintoneApi.UPDATE_RECORD_STATUSES, request, this.handlers);
    }

    @ConstructorProperties(value={"client", "handlers"})
    RecordClient(InternalClient client, List<ResponseHandler> handlers) {
        this.client = client;
        this.handlers = handlers;
    }
}

