/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.kintone.client.InternalClient;
import com.kintone.client.KintoneApi;
import com.kintone.client.KintoneHttpMethod;
import com.kintone.client.ResponseHandler;
import com.kintone.client.api.schema.GetApiListResponseBody;
import com.kintone.client.api.schema.GetApiSchemaResponseBody;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;

public class SchemaClient {
    private final InternalClient client;
    private final List<ResponseHandler> handlers;

    public GetApiListResponseBody getApiList() {
        return (GetApiListResponseBody)this.client.call(KintoneApi.GET_API_LIST, null, this.handlers);
    }

    public GetApiSchemaResponseBody getApiSchema(KintoneApi api) {
        if (api == KintoneApi.GET_API_LIST) {
            return null;
        }
        String path = "/k/v1/" + this.toApiPath(api);
        return this.client.call(KintoneHttpMethod.GET, path, null, GetApiSchemaResponseBody.class, this.handlers);
    }

    public GetApiSchemaResponseBody getApiSchema(String link) {
        boolean valid = Arrays.stream(KintoneApi.values()).anyMatch(api -> api != KintoneApi.GET_API_LIST && this.toApiPath((KintoneApi)((Object)api)).equals(link));
        if (!valid) {
            return null;
        }
        String path = "/k/v1/" + link;
        return this.client.call(KintoneHttpMethod.GET, path, null, GetApiSchemaResponseBody.class, this.handlers);
    }

    private String toApiPath(KintoneApi api) {
        return "apis/" + api.getEndpoint() + "/" + api.getMethod().toString().toLowerCase() + ".json";
    }

    @ConstructorProperties(value={"client", "handlers"})
    SchemaClient(InternalClient client, List<ResponseHandler> handlers) {
        this.client = client;
        this.handlers = handlers;
    }
}

