/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.kintone.client.InternalClient;
import com.kintone.client.KintoneApi;
import com.kintone.client.ResponseHandler;
import com.kintone.client.api.space.AddGuestsRequest;
import com.kintone.client.api.space.AddGuestsResponseBody;
import com.kintone.client.api.space.AddSpaceFromTemplateRequest;
import com.kintone.client.api.space.AddSpaceFromTemplateResponseBody;
import com.kintone.client.api.space.AddThreadCommentRequest;
import com.kintone.client.api.space.AddThreadCommentResponseBody;
import com.kintone.client.api.space.DeleteGuestsRequest;
import com.kintone.client.api.space.DeleteGuestsResponseBody;
import com.kintone.client.api.space.DeleteSpaceRequest;
import com.kintone.client.api.space.DeleteSpaceResponseBody;
import com.kintone.client.api.space.GetSpaceMembersRequest;
import com.kintone.client.api.space.GetSpaceMembersResponseBody;
import com.kintone.client.api.space.GetSpaceRequest;
import com.kintone.client.api.space.GetSpaceResponseBody;
import com.kintone.client.api.space.UpdateSpaceBodyRequest;
import com.kintone.client.api.space.UpdateSpaceBodyResponseBody;
import com.kintone.client.api.space.UpdateSpaceGuestsRequest;
import com.kintone.client.api.space.UpdateSpaceGuestsResponseBody;
import com.kintone.client.api.space.UpdateSpaceMembersRequest;
import com.kintone.client.api.space.UpdateSpaceMembersResponseBody;
import com.kintone.client.api.space.UpdateThreadRequest;
import com.kintone.client.api.space.UpdateThreadResponseBody;
import com.kintone.client.model.space.AddedSpaceMember;
import com.kintone.client.model.space.GuestUser;
import com.kintone.client.model.space.SpaceMember;
import com.kintone.client.model.space.ThreadComment;
import java.beans.ConstructorProperties;
import java.util.List;

public class SpaceClient {
    private final InternalClient client;
    private final List<ResponseHandler> handlers;

    public void addGuests(List<GuestUser> guests) {
        AddGuestsRequest req = new AddGuestsRequest();
        req.setGuests(guests);
        this.addGuests(req);
    }

    public AddGuestsResponseBody addGuests(AddGuestsRequest request) {
        return (AddGuestsResponseBody)this.client.call(KintoneApi.ADD_GUESTS, request, this.handlers);
    }

    public AddSpaceFromTemplateResponseBody addSpaceFromTemplate(AddSpaceFromTemplateRequest request) {
        return (AddSpaceFromTemplateResponseBody)this.client.call(KintoneApi.ADD_SPACE_FROM_TEMPLATE, request, this.handlers);
    }

    public long addThreadComment(long spaceId, long threadId, ThreadComment comment) {
        AddThreadCommentRequest req = new AddThreadCommentRequest();
        req.setSpace(spaceId);
        req.setThread(threadId);
        req.setComment(comment);
        return this.addThreadComment(req).getId();
    }

    public AddThreadCommentResponseBody addThreadComment(AddThreadCommentRequest request) {
        return (AddThreadCommentResponseBody)this.client.call(KintoneApi.ADD_THREAD_COMMENT, request, this.handlers);
    }

    public void deleteGuests(List<String> guests) {
        DeleteGuestsRequest req = new DeleteGuestsRequest();
        req.setGuests(guests);
        this.deleteGuests(req);
    }

    public DeleteGuestsResponseBody deleteGuests(DeleteGuestsRequest request) {
        return (DeleteGuestsResponseBody)this.client.call(KintoneApi.DELETE_GUESTS, request, this.handlers);
    }

    public void deleteSpace(long spaceId) {
        DeleteSpaceRequest req = new DeleteSpaceRequest();
        req.setId(spaceId);
        this.deleteSpace(req);
    }

    public DeleteSpaceResponseBody deleteSpace(DeleteSpaceRequest request) {
        return (DeleteSpaceResponseBody)this.client.call(KintoneApi.DELETE_SPACE, request, this.handlers);
    }

    public GetSpaceResponseBody getSpace(long spaceId) {
        GetSpaceRequest req = new GetSpaceRequest();
        req.setId(spaceId);
        return this.getSpace(req);
    }

    public GetSpaceResponseBody getSpace(GetSpaceRequest request) {
        return (GetSpaceResponseBody)this.client.call(KintoneApi.GET_SPACE, request, this.handlers);
    }

    public List<AddedSpaceMember> getSpaceMembers(long spaceId) {
        GetSpaceMembersRequest req = new GetSpaceMembersRequest();
        req.setId(spaceId);
        return this.getSpaceMembers(req).getMembers();
    }

    public GetSpaceMembersResponseBody getSpaceMembers(GetSpaceMembersRequest request) {
        return (GetSpaceMembersResponseBody)this.client.call(KintoneApi.GET_SPACE_MEMBERS, request, this.handlers);
    }

    public void updateSpaceBody(long spaceId, String body) {
        UpdateSpaceBodyRequest req = new UpdateSpaceBodyRequest();
        req.setId(spaceId);
        req.setBody(body);
        this.updateSpaceBody(req);
    }

    public UpdateSpaceBodyResponseBody updateSpaceBody(UpdateSpaceBodyRequest request) {
        return (UpdateSpaceBodyResponseBody)this.client.call(KintoneApi.UPDATE_SPACE_BODY, request, this.handlers);
    }

    public void updateSpaceGuests(long spaceId, List<String> guests) {
        UpdateSpaceGuestsRequest req = new UpdateSpaceGuestsRequest();
        req.setId(spaceId);
        req.setGuests(guests);
        this.updateSpaceGuests(req);
    }

    public UpdateSpaceGuestsResponseBody updateSpaceGuests(UpdateSpaceGuestsRequest request) {
        return (UpdateSpaceGuestsResponseBody)this.client.call(KintoneApi.UPDATE_SPACE_GUESTS, request, this.handlers);
    }

    public void updateSpaceMembers(long spaceId, List<SpaceMember> members) {
        UpdateSpaceMembersRequest req = new UpdateSpaceMembersRequest();
        req.setId(spaceId);
        req.setMembers(members);
        this.updateSpaceMembers(req);
    }

    public UpdateSpaceMembersResponseBody updateSpaceMembers(UpdateSpaceMembersRequest request) {
        return (UpdateSpaceMembersResponseBody)this.client.call(KintoneApi.UPDATE_SPACE_MEMBERS, request, this.handlers);
    }

    public void updateThread(long threadId, String name, String body) {
        UpdateThreadRequest req = new UpdateThreadRequest();
        req.setId(threadId);
        req.setName(name);
        req.setBody(body);
        this.updateThread(req);
    }

    public UpdateThreadResponseBody updateThread(UpdateThreadRequest request) {
        return (UpdateThreadResponseBody)this.client.call(KintoneApi.UPDATE_THREAD, request, this.handlers);
    }

    @ConstructorProperties(value={"client", "handlers"})
    SpaceClient(InternalClient client, List<ResponseHandler> handlers) {
        this.client = client;
        this.handlers = handlers;
    }
}

