/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client.model.record;

import com.kintone.client.model.FileBody;
import com.kintone.client.model.Group;
import com.kintone.client.model.Organization;
import com.kintone.client.model.User;
import com.kintone.client.model.record.CalcFieldValue;
import com.kintone.client.model.record.CategoryFieldValue;
import com.kintone.client.model.record.CheckBoxFieldValue;
import com.kintone.client.model.record.CreatedTimeFieldValue;
import com.kintone.client.model.record.CreatorFieldValue;
import com.kintone.client.model.record.DateFieldValue;
import com.kintone.client.model.record.DateTimeFieldValue;
import com.kintone.client.model.record.DropDownFieldValue;
import com.kintone.client.model.record.FieldType;
import com.kintone.client.model.record.FieldValue;
import com.kintone.client.model.record.FileFieldValue;
import com.kintone.client.model.record.GroupSelectFieldValue;
import com.kintone.client.model.record.LinkFieldValue;
import com.kintone.client.model.record.ModifierFieldValue;
import com.kintone.client.model.record.MultiLineTextFieldValue;
import com.kintone.client.model.record.MultiSelectFieldValue;
import com.kintone.client.model.record.NumberFieldValue;
import com.kintone.client.model.record.OrganizationSelectFieldValue;
import com.kintone.client.model.record.RadioButtonFieldValue;
import com.kintone.client.model.record.RecordNumberFieldValue;
import com.kintone.client.model.record.RichTextFieldValue;
import com.kintone.client.model.record.SingleLineTextFieldValue;
import com.kintone.client.model.record.StatusAssigneeFieldValue;
import com.kintone.client.model.record.StatusFieldValue;
import com.kintone.client.model.record.SubtableFieldValue;
import com.kintone.client.model.record.TableRow;
import com.kintone.client.model.record.TimeFieldValue;
import com.kintone.client.model.record.UpdatedTimeFieldValue;
import com.kintone.client.model.record.UserSelectFieldValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Record {
    private final Map<String, FieldValue> fields = new HashMap<String, FieldValue>();
    private final Map<FieldType, String> builtinCodes = new HashMap<FieldType, String>();
    private final Long id;
    private final Long revision;

    public static Record newFrom(Record src) {
        Record dst = new Record();
        for (Map.Entry<String, FieldValue> entry : src.fields.entrySet()) {
            if (entry.getValue().isBuiltin()) continue;
            dst.putField(entry.getKey(), entry.getValue());
        }
        return dst;
    }

    public Record() {
        this.id = null;
        this.revision = null;
    }

    public Record(Long id, Long revision) {
        this.id = id;
        this.revision = revision;
    }

    public Long getId() {
        return this.id;
    }

    public Long getRevision() {
        return this.revision;
    }

    public Record putField(String fieldCode, FieldValue value) {
        String prevCode;
        if (value == null) {
            return this.removeField(fieldCode);
        }
        if (value.isBuiltin() && (prevCode = this.builtinCodes.put(value.getType(), fieldCode)) != null) {
            this.fields.remove(prevCode);
        }
        this.fields.put(fieldCode, value);
        return this;
    }

    public Record removeField(String fieldCode) {
        FieldValue removed = this.fields.remove(fieldCode);
        if (removed != null && removed.isBuiltin()) {
            this.builtinCodes.remove((Object)removed.getType());
        }
        return this;
    }

    public FieldValue getFieldValue(String fieldCode) {
        return this.fields.get(fieldCode);
    }

    public Set<String> getFieldCodes(boolean includeBuiltins) {
        HashSet<String> fieldCodes = new HashSet<String>(this.fields.keySet());
        if (!includeBuiltins) {
            fieldCodes.removeAll(this.builtinCodes.values());
        }
        return fieldCodes;
    }

    public FieldType getFieldType(String fieldCode) {
        FieldValue value = this.fields.get(fieldCode);
        return value == null ? null : value.getType();
    }

    public String getSingleLineTextFieldValue(String fieldCode) {
        SingleLineTextFieldValue value = (SingleLineTextFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<TableRow> getSubtableFieldValue(String fieldCode) {
        SubtableFieldValue value = (SubtableFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getRows();
    }

    public String getLinkFieldValue(String fieldCode) {
        LinkFieldValue value = (LinkFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<Group> getGroupSelectFieldValue(String fieldCode) {
        GroupSelectFieldValue value = (GroupSelectFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public List<String> getMultiSelectFieldValue(String fieldCode) {
        MultiSelectFieldValue value = (MultiSelectFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public String getRadioButtonFieldValue(String fieldCode) {
        RadioButtonFieldValue value = (RadioButtonFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public LocalDate getDateFieldValue(String fieldCode) {
        DateFieldValue value = (DateFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<Organization> getOrganizationSelectFieldValue(String fieldCode) {
        OrganizationSelectFieldValue value = (OrganizationSelectFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public ZonedDateTime getDateTimeFieldValue(String fieldCode) {
        DateTimeFieldValue value = (DateTimeFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<User> getUserSelectFieldValue(String fieldCode) {
        UserSelectFieldValue value = (UserSelectFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public List<String> getCheckBoxFieldValue(String fieldCode) {
        CheckBoxFieldValue value = (CheckBoxFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public BigDecimal getCalcFieldValue(String fieldCode) {
        CalcFieldValue value = (CalcFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getCalcFieldRawValue(String fieldCode) {
        CalcFieldValue value = (CalcFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getRawValue();
    }

    public LocalTime getTimeFieldValue(String fieldCode) {
        TimeFieldValue value = (TimeFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public BigDecimal getNumberFieldValue(String fieldCode) {
        NumberFieldValue value = (NumberFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getDropDownFieldValue(String fieldCode) {
        DropDownFieldValue value = (DropDownFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getMultiLineTextFieldValue(String fieldCode) {
        MultiLineTextFieldValue value = (MultiLineTextFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getRichTextFieldValue(String fieldCode) {
        RichTextFieldValue value = (RichTextFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<FileBody> getFileFieldValue(String fieldCode) {
        FileFieldValue value = (FileFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public List<String> getCategoryFieldValue() {
        CategoryFieldValue value = (CategoryFieldValue)this.getBuiltinFieldValue(FieldType.CATEGORY);
        return value == null ? null : value.getValues();
    }

    public ZonedDateTime getCreatedTimeFieldValue() {
        CreatedTimeFieldValue value = (CreatedTimeFieldValue)this.getBuiltinFieldValue(FieldType.CREATED_TIME);
        return value == null ? null : value.getValue();
    }

    public User getCreatorFieldValue() {
        CreatorFieldValue value = (CreatorFieldValue)this.getBuiltinFieldValue(FieldType.CREATOR);
        return value == null ? null : value.getValue();
    }

    public User getModifierFieldValue() {
        ModifierFieldValue value = (ModifierFieldValue)this.getBuiltinFieldValue(FieldType.MODIFIER);
        return value == null ? null : value.getValue();
    }

    public String getRecordNumberFieldValue() {
        RecordNumberFieldValue value = (RecordNumberFieldValue)this.getBuiltinFieldValue(FieldType.RECORD_NUMBER);
        return value == null ? null : value.getValue();
    }

    public String getStatusFieldValue() {
        StatusFieldValue value = (StatusFieldValue)this.getBuiltinFieldValue(FieldType.STATUS);
        return value == null ? null : value.getValue();
    }

    public List<User> getStatusAssigneeFieldValue() {
        StatusAssigneeFieldValue value = (StatusAssigneeFieldValue)this.getBuiltinFieldValue(FieldType.STATUS_ASSIGNEE);
        return value == null ? null : value.getValues();
    }

    public ZonedDateTime getUpdatedTimeFieldValue() {
        UpdatedTimeFieldValue value = (UpdatedTimeFieldValue)this.getBuiltinFieldValue(FieldType.UPDATED_TIME);
        return value == null ? null : value.getValue();
    }

    private FieldValue getBuiltinFieldValue(FieldType type) {
        String fieldCode = this.builtinCodes.get((Object)type);
        return fieldCode == null ? null : this.fields.get(fieldCode);
    }
}

