/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client.model.record;

import com.kintone.client.model.FileBody;
import com.kintone.client.model.Group;
import com.kintone.client.model.Organization;
import com.kintone.client.model.User;
import com.kintone.client.model.record.CalcFieldValue;
import com.kintone.client.model.record.CheckBoxFieldValue;
import com.kintone.client.model.record.DateFieldValue;
import com.kintone.client.model.record.DateTimeFieldValue;
import com.kintone.client.model.record.DropDownFieldValue;
import com.kintone.client.model.record.FieldType;
import com.kintone.client.model.record.FieldValue;
import com.kintone.client.model.record.FileFieldValue;
import com.kintone.client.model.record.GroupSelectFieldValue;
import com.kintone.client.model.record.LinkFieldValue;
import com.kintone.client.model.record.MultiLineTextFieldValue;
import com.kintone.client.model.record.MultiSelectFieldValue;
import com.kintone.client.model.record.NumberFieldValue;
import com.kintone.client.model.record.OrganizationSelectFieldValue;
import com.kintone.client.model.record.RadioButtonFieldValue;
import com.kintone.client.model.record.RichTextFieldValue;
import com.kintone.client.model.record.SingleLineTextFieldValue;
import com.kintone.client.model.record.TimeFieldValue;
import com.kintone.client.model.record.UserSelectFieldValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableRow {
    private final Map<String, FieldValue> fields = new HashMap<String, FieldValue>();
    private final Long id;

    public static TableRow newFrom(TableRow src) {
        TableRow dst = new TableRow();
        dst.fields.putAll(src.fields);
        return dst;
    }

    public TableRow() {
        this.id = null;
    }

    public TableRow(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public TableRow putField(String fieldCode, FieldValue value) {
        if (value == null) {
            return this.removeField(fieldCode);
        }
        this.fields.put(fieldCode, value);
        return this;
    }

    public TableRow removeField(String fieldCode) {
        this.fields.remove(fieldCode);
        return this;
    }

    public FieldValue getFieldValue(String fieldCode) {
        return this.fields.get(fieldCode);
    }

    public Set<String> getFieldCodes() {
        return new HashSet<String>(this.fields.keySet());
    }

    public FieldType getFieldType(String fieldCode) {
        FieldValue value = this.fields.get(fieldCode);
        return value == null ? null : value.getType();
    }

    public String getSingleLineTextFieldValue(String fieldCode) {
        SingleLineTextFieldValue value = (SingleLineTextFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getLinkFieldValue(String fieldCode) {
        LinkFieldValue value = (LinkFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<Group> getGroupSelectFieldValue(String fieldCode) {
        GroupSelectFieldValue value = (GroupSelectFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public List<String> getMultiSelectFieldValue(String fieldCode) {
        MultiSelectFieldValue value = (MultiSelectFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public String getRadioButtonFieldValue(String fieldCode) {
        RadioButtonFieldValue value = (RadioButtonFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public LocalDate getDateFieldValue(String fieldCode) {
        DateFieldValue value = (DateFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<Organization> getOrganizationSelectFieldValue(String fieldCode) {
        OrganizationSelectFieldValue value = (OrganizationSelectFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public ZonedDateTime getDateTimeFieldValue(String fieldCode) {
        DateTimeFieldValue value = (DateTimeFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<User> getUserSelectFieldValue(String fieldCode) {
        UserSelectFieldValue value = (UserSelectFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public List<String> getCheckBoxFieldValue(String fieldCode) {
        CheckBoxFieldValue value = (CheckBoxFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }

    public BigDecimal getCalcFieldValue(String fieldCode) {
        CalcFieldValue value = (CalcFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getCalcFieldRawValue(String fieldCode) {
        CalcFieldValue value = (CalcFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getRawValue();
    }

    public LocalTime getTimeFieldValue(String fieldCode) {
        TimeFieldValue value = (TimeFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public BigDecimal getNumberFieldValue(String fieldCode) {
        NumberFieldValue value = (NumberFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getDropDownFieldValue(String fieldCode) {
        DropDownFieldValue value = (DropDownFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getMultiLineTextFieldValue(String fieldCode) {
        MultiLineTextFieldValue value = (MultiLineTextFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public String getRichTextFieldValue(String fieldCode) {
        RichTextFieldValue value = (RichTextFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValue();
    }

    public List<FileBody> getFileFieldValue(String fieldCode) {
        FileFieldValue value = (FileFieldValue)this.fields.get(fieldCode);
        return value == null ? null : value.getValues();
    }
}

