/*
 * Decompiled with CFR 0.152.
 */
package com.kirekov.sneaky;

import com.kirekov.sneaky.lambda.CheckedBiConsumer;
import com.kirekov.sneaky.lambda.CheckedBiFunction;
import com.kirekov.sneaky.lambda.CheckedBiPredicate;
import com.kirekov.sneaky.lambda.CheckedConsumer;
import com.kirekov.sneaky.lambda.CheckedFunction;
import com.kirekov.sneaky.lambda.CheckedPredicate;
import com.kirekov.sneaky.lambda.CheckedSupplier;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Sneaky {
    private Sneaky() {
    }

    public static <T> Consumer<T> consumer(CheckedConsumer<T> checkedConsumer) {
        return value -> {
            try {
                checkedConsumer.accept(value);
            }
            catch (Exception e) {
                Sneaky.throwUnchecked(e);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> biConsumer(CheckedBiConsumer<T, U> checkedBiConsumer) {
        return (t, u) -> {
            try {
                checkedBiConsumer.accept(t, u);
            }
            catch (Exception e) {
                Sneaky.throwUnchecked(e);
            }
        };
    }

    public static <T> Predicate<T> predicate(CheckedPredicate<T> checkedPredicate) {
        return t -> {
            try {
                return checkedPredicate.test(t);
            }
            catch (Exception e) {
                Sneaky.throwUnchecked(e);
                return false;
            }
        };
    }

    public static <T, U> BiPredicate<T, U> biPredicate(CheckedBiPredicate<T, U> checkedBiPredicate) {
        return (t, u) -> {
            try {
                return checkedBiPredicate.test(t, u);
            }
            catch (Exception e) {
                Sneaky.throwUnchecked(e);
                return false;
            }
        };
    }

    public static <T> Supplier<T> supplier(CheckedSupplier<T> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Exception e) {
                Sneaky.throwUnchecked(e);
                return null;
            }
        };
    }

    public static <T, R> Function<T, R> function(CheckedFunction<T, R> checkedFunction) {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                Sneaky.throwUnchecked(e);
                return null;
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> biFunction(CheckedBiFunction<T, U, R> checkedBiFunction) {
        return (t, u) -> {
            try {
                return checkedBiFunction.apply(t, u);
            }
            catch (Exception e) {
                Sneaky.throwUnchecked(e);
                return null;
            }
        };
    }

    public static <T extends Exception> void throwUnchecked(Exception exception) throws T {
        throw exception;
    }
}

