/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.core.k8deployment.helmplugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractHelmMojo
extends AbstractMojo {
    @Parameter(property="helmExecutableDirectory", defaultValue="${project.build.directory}/helm")
    private String helmExecuteableDirectory;
    @Parameter(property="helmExecutable", defaultValue="${project.build.directory}/helm/linux-amd64/helm")
    private String helmExecuteable;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/helm/repo")
    private String outputDirectory;
    @Parameter(property="excludes")
    private String[] excludes;
    @Parameter(property="chartDirectory", required=true)
    private String chartDirectory;
    @Parameter(property="helmRepoUrl", required=true)
    private String helmRepoUrl;
    @Parameter(property="indexFileForMerge")
    private String indexFileForMerge;
    @Parameter(property="helmDownloadUrl")
    private String helmDownloadUrl;

    void callCli(String command, String errorMessage, final boolean verbose) throws MojoExecutionException {
        int exitValue;
        try {
            final Process p = Runtime.getRuntime().exec(command);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    try {
                        String errorLine;
                        String inputLine;
                        while ((inputLine = input.readLine()) != null) {
                            if (verbose) {
                                AbstractHelmMojo.this.getLog().info((CharSequence)inputLine);
                                continue;
                            }
                            AbstractHelmMojo.this.getLog().debug((CharSequence)inputLine);
                        }
                        while ((errorLine = error.readLine()) != null) {
                            AbstractHelmMojo.this.getLog().error((CharSequence)errorLine);
                        }
                    }
                    catch (IOException e) {
                        AbstractHelmMojo.this.getLog().error((Throwable)e);
                    }
                }
            }).start();
            p.waitFor();
            exitValue = p.exitValue();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing command [" + command + "]", e);
        }
        if (exitValue != 0) {
            throw new MojoExecutionException(errorMessage);
        }
    }

    List<String> getChartDirectories(String path) throws MojoExecutionException {
        try {
            return Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(p -> p.getFileName().toString().equalsIgnoreCase("chart.yaml")).map(p -> p.getParent().toString()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan chart directory at " + path, (Exception)e);
        }
    }

    public String getHelmExecuteable() {
        return this.helmExecuteable;
    }

    public void setHelmExecuteable(String helmExecuteable) {
        this.helmExecuteable = helmExecuteable;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getHelmExecuteableDirectory() {
        return this.helmExecuteableDirectory;
    }

    public void setHelmExecuteableDirectory(String helmExecuteableDirectory) {
        this.helmExecuteableDirectory = helmExecuteableDirectory;
    }

    public String getHelmRepoUrl() {
        return this.helmRepoUrl;
    }

    public void setHelmRepoUrl(String helmRepoUrl) {
        this.helmRepoUrl = helmRepoUrl;
    }

    public String getIndexFileForMerge() {
        return this.indexFileForMerge;
    }

    public void setIndexFileForMerge(String indexFileForMerge) {
        this.indexFileForMerge = indexFileForMerge;
    }

    public String getHelmDownloadUrl() {
        return this.helmDownloadUrl;
    }

    public void setHelmDownloadUrl(String helmDownloadUrl) {
        this.helmDownloadUrl = helmDownloadUrl;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String getChartDirectory() {
        return this.chartDirectory;
    }

    public void setChartDirectory(String chartDirectory) {
        this.chartDirectory = chartDirectory;
    }
}

