/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.core.k8deployment.helmplugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractHelmMojo
extends AbstractMojo {
    @Parameter(property="helm.executableDirectory", defaultValue="${project.build.directory}/helm")
    private String helmExecuteableDirectory;
    @Parameter(property="helm.executable", defaultValue="${project.build.directory}/helm/linux-amd64/helm")
    private String helmExecuteable;
    @Parameter(property="helm.outputDirectory", defaultValue="${project.build.directory}/helm/repo")
    private String outputDirectory;
    @Parameter(property="helm.excludes")
    private String[] excludes;
    @Parameter(property="helm.chartDirectory", required=true)
    private String chartDirectory;
    @Parameter(property="helm.chartVersion")
    private String chartVersion;
    @Parameter(property="helm.repoUrl", required=true)
    private String helmRepoUrl;
    @Parameter(property="helm.uploadUrl", required=true)
    private String helmUploadUrl;
    @Parameter(property="helm.indexFileForMerge")
    private String indexFileForMerge;
    @Parameter(property="helm.downloadUrl")
    private String helmDownloadUrl;
    @Parameter(property="helm.homeDirectory")
    private String helmHomeDirectory;

    void callCli(String command, String errorMessage, boolean verbose) throws MojoExecutionException {
        int exitValue;
        try {
            Process p = Runtime.getRuntime().exec(command);
            new Thread(() -> {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String errorLine;
                    String inputLine;
                    while ((inputLine = input.readLine()) != null) {
                        if (verbose) {
                            this.getLog().info((CharSequence)inputLine);
                            continue;
                        }
                        this.getLog().debug((CharSequence)inputLine);
                    }
                    while ((errorLine = error.readLine()) != null) {
                        this.getLog().error((CharSequence)errorLine);
                    }
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }).start();
            p.waitFor();
            exitValue = p.exitValue();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing command [" + command + "]", e);
        }
        if (exitValue != 0) {
            throw new MojoExecutionException(errorMessage);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> getChartDirectories(String path) throws MojoExecutionException {
        try (Stream<Path> files = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            List<String> list = files.filter(p -> p.getFileName().toString().equalsIgnoreCase("chart.yaml")).map(p -> p.getParent().toString()).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan chart directory at " + path, (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> getChartTgzs(String path) throws MojoExecutionException {
        try (Stream<Path> files = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            List<String> list = files.filter(p -> p.getFileName().toString().endsWith("tgz")).map(p -> p.toString()).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan repo directory at " + path, (Exception)e);
        }
    }

    public String getHelmExecuteable() {
        return this.helmExecuteable;
    }

    public void setHelmExecuteable(String helmExecuteable) {
        this.helmExecuteable = helmExecuteable;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getHelmExecuteableDirectory() {
        return this.helmExecuteableDirectory;
    }

    public void setHelmExecuteableDirectory(String helmExecuteableDirectory) {
        this.helmExecuteableDirectory = helmExecuteableDirectory;
    }

    public String getHelmRepoUrl() {
        return this.helmRepoUrl;
    }

    public void setHelmRepoUrl(String helmRepoUrl) {
        this.helmRepoUrl = helmRepoUrl;
    }

    public String getIndexFileForMerge() {
        return this.indexFileForMerge;
    }

    public void setIndexFileForMerge(String indexFileForMerge) {
        this.indexFileForMerge = indexFileForMerge;
    }

    public String getHelmDownloadUrl() {
        return this.helmDownloadUrl;
    }

    public void setHelmDownloadUrl(String helmDownloadUrl) {
        this.helmDownloadUrl = helmDownloadUrl;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String getChartDirectory() {
        return this.chartDirectory;
    }

    public void setChartDirectory(String chartDirectory) {
        this.chartDirectory = chartDirectory;
    }

    public String getHelmHomeDirectory() {
        return this.helmHomeDirectory;
    }

    public void setHelmHomeDirectory(String helmHomeDirectory) {
        this.helmHomeDirectory = helmHomeDirectory;
    }

    public String getHelmUploadUrl() {
        return this.helmUploadUrl;
    }

    public void setHelmUploadUrl(String helmUploadUrl) {
        this.helmUploadUrl = helmUploadUrl;
    }

    public String getChartVersion() {
        return this.chartVersion;
    }

    public void setChartVersion(String chartVersion) {
        this.chartVersion = chartVersion;
    }
}

