/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.core.k8deployment.helmplugin;

import com.kiwigrid.core.k8deployment.helmplugin.AbstractHelmMojo;
import com.kiwigrid.core.k8deployment.helmplugin.HelmRepository;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="init", defaultPhase=LifecyclePhase.INITIALIZE)
public class InitMojo
extends AbstractHelmMojo {
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Initializing Helm...");
        this.getLog().info((CharSequence)"Creating output directory...");
        this.callCli("mkdir -p " + this.getOutputDirectory(), "Unable to create output directory at " + this.getOutputDirectory(), false);
        this.getLog().info((CharSequence)"Downloading Helm...");
        this.callCli("wget -qO " + this.getHelmExecuteableDirectory() + File.separator + "helm.tar.gz " + this.getHelmDownloadUrl(), "Unable to download helm", false);
        this.getLog().info((CharSequence)"Unpacking Helm...");
        this.callCli("tar -xf " + this.getHelmExecuteableDirectory() + File.separator + "helm.tar.gz --strip=1 --directory=" + this.getHelmExecuteableDirectory(), "Unable to unpack helm to " + this.getHelmExecuteableDirectory(), false);
        this.getLog().info((CharSequence)"Run helm init...");
        this.callCli(this.getHelmExecuteableDirectory() + File.separator + "helm init --client-only" + (StringUtils.isNotEmpty((String)this.getHelmHomeDirectory()) ? " --home=" + this.getHelmHomeDirectory() : ""), "Unable to call helm init", false);
        if (this.getHelmExtraRepos() != null) {
            for (HelmRepository repository : this.getHelmExtraRepos()) {
                this.getLog().info((CharSequence)("Adding repo " + repository));
                this.callCli(this.getHelmExecuteableDirectory() + File.separator + "helm repo add " + repository.getName() + ": " + repository.getUrl(), "Unable add repo", false);
            }
        }
    }
}

