/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.core.k8deployment.helmplugin;

import com.kiwigrid.core.k8deployment.helmplugin.AbstractHelmMojo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public class UploadMojo
extends AbstractHelmMojo {
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Uploading to " + this.getHelmUploadUrl() + "\n"));
        for (String chartPackageFile : this.getChartTgzs(this.getChartDirectory())) {
            this.getLog().info((CharSequence)("Uploading " + chartPackageFile + "..."));
            try {
                this.uploadSingle(chartPackageFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error uploading " + chartPackageFile + " to " + this.getHelmUploadUrl(), (Exception)e);
            }
        }
    }

    private void uploadSingle(String file) throws IOException {
        String response;
        HttpURLConnection connection = (HttpURLConnection)new URL(this.getHelmUploadUrl()).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/gzip");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)connection.getOutputStream());
        }
        if (connection.getResponseCode() >= 400) {
            response = IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charset.defaultCharset());
            this.getLog().error((CharSequence)(Integer.valueOf(connection.getResponseCode()).toString() + " - " + response));
        } else {
            response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset());
            this.getLog().info((CharSequence)(Integer.valueOf(connection.getResponseCode()).toString() + " - " + response));
        }
        connection.disconnect();
    }
}

