/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.core.k8deployment.helmplugin;

import com.kiwigrid.core.k8deployment.helmplugin.AbstractHelmMojo;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageMojo
extends AbstractHelmMojo {
    public void execute() throws MojoExecutionException {
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            if (this.getExcludes() != null && Arrays.asList(this.getExcludes()).contains(inputDirectory)) {
                this.getLog().debug((CharSequence)("Skip excluded directory " + inputDirectory));
                continue;
            }
            this.getLog().info((CharSequence)("Packaging chart " + inputDirectory + "..."));
            String helmCommand = this.getHelmExecuteablePath() + " package " + inputDirectory + " -d " + this.getOutputDirectory() + (StringUtils.isNotEmpty((String)this.getHelmHomeDirectory()) ? " --home=" + this.getHelmHomeDirectory() : "");
            if (this.getChartVersion() != null) {
                this.getLog().info((CharSequence)String.format("Setting chart version to %s", this.getChartVersion()));
                helmCommand = helmCommand + " --version " + this.getChartVersion();
            }
            this.callCli(helmCommand, "Unable to package chart at " + inputDirectory, true);
        }
    }
}

