/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import com.kiwigrid.helm.maven.plugin.HelmRepository;
import com.kiwigrid.helm.maven.plugin.exception.BadUploadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public class UploadMojo
extends AbstractHelmMojo {
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Uploading to " + this.getHelmUploadUrl() + "\n"));
        for (String chartPackageFile : this.getChartTgzs(this.getOutputDirectory())) {
            this.getLog().info((CharSequence)("Uploading " + chartPackageFile + "..."));
            try {
                this.uploadSingle(chartPackageFile);
            }
            catch (BadUploadException | IOException e) {
                this.getLog().error((CharSequence)e.getMessage());
                throw new MojoExecutionException("Error uploading " + chartPackageFile + " to " + this.getHelmUploadUrl(), e);
            }
        }
    }

    private void uploadSingle(String file) throws IOException, BadUploadException {
        String response;
        File fileToUpload = new File(file);
        String uploadUrl = this.getHelmUploadUrl() + fileToUpload.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.configureAuthenticationIfSet();
        try (FileInputStream fileInputStream = new FileInputStream(fileToUpload);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)connection.getOutputStream());
        }
        if (connection.getResponseCode() >= 400) {
            response = IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charset.defaultCharset());
            throw new BadUploadException(response);
        }
        response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset());
        this.getLog().info((CharSequence)(Integer.toString(connection.getResponseCode()) + " - " + response));
        connection.disconnect();
    }

    private void configureAuthenticationIfSet() {
        if (this.getChartVersion().endsWith("-SNAPSHOT") && this.getUploadRepoSnapshot() != null && StringUtils.isNotEmpty((String)this.getUploadRepoSnapshot().getUsername())) {
            this.setAuthenticatorForRepo(this.getUploadRepoSnapshot());
        } else if (!this.getChartVersion().endsWith("-SNAPSHOT") && this.getUploadRepoStable() != null && this.getUploadRepoStable().getUsername() != null) {
            this.setAuthenticatorForRepo(this.getUploadRepoStable());
        }
    }

    private void setAuthenticatorForRepo(final HelmRepository uploadRepo) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(uploadRepo.getUsername(), uploadRepo.getPassword().toCharArray());
            }
        });
    }
}

