/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import com.kiwigrid.helm.maven.plugin.exception.BadUploadException;
import com.kiwigrid.helm.maven.plugin.pojo.HelmRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public class UploadMojo
extends AbstractHelmMojo {
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Uploading to " + this.getHelmUploadUrl() + "\n"));
        for (String chartPackageFile : this.getChartTgzs(this.getOutputDirectory())) {
            this.getLog().info((CharSequence)("Uploading " + chartPackageFile + "..."));
            try {
                this.uploadSingle(chartPackageFile);
            }
            catch (BadUploadException | IOException e) {
                this.getLog().error((CharSequence)e.getMessage());
                throw new MojoExecutionException("Error uploading " + chartPackageFile + " to " + this.getHelmUploadUrl(), e);
            }
        }
    }

    private void uploadSingle(String file) throws IOException, BadUploadException, MojoExecutionException {
        String response;
        HttpURLConnection connection;
        File fileToUpload = new File(file);
        HelmRepository uploadRepo = this.getHelmUploadRepo();
        if (uploadRepo.getType() == null) {
            throw new IllegalArgumentException("Repository type missing. Check your plugin configuration.");
        }
        switch (uploadRepo.getType()) {
            case ARTIFACTORY: {
                connection = this.getConnectionForUploadToArtifactory(fileToUpload);
                break;
            }
            case CHARTMUSEUM: {
                connection = this.getConnectionForUploadToChartmuseum();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type for upload.");
            }
        }
        try (FileInputStream fileInputStream = new FileInputStream(fileToUpload);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)connection.getOutputStream());
        }
        if (connection.getResponseCode() >= 400) {
            response = IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charset.defaultCharset());
            throw new BadUploadException(response);
        }
        response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset());
        this.getLog().info((CharSequence)(Integer.toString(connection.getResponseCode()) + " - " + response));
        connection.disconnect();
    }

    protected HttpURLConnection getConnectionForUploadToChartmuseum() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.getHelmUploadUrl()).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/gzip");
        return connection;
    }

    protected HttpURLConnection getConnectionForUploadToArtifactory(File file) throws IOException, MojoExecutionException {
        String uploadUrl = this.getHelmUploadUrl();
        if (!uploadUrl.endsWith("/")) {
            uploadUrl = uploadUrl + "/";
        }
        uploadUrl = uploadUrl + file.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.verifyAndSetAuthentication();
        return connection;
    }

    private void verifyAndSetAuthentication() throws MojoExecutionException {
        final PasswordAuthentication authentication = this.getAuthentication(this.getHelmUploadRepo());
        if (authentication == null) {
            throw new IllegalArgumentException("Credentials has to be configured for uploading to Artifactory.");
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return authentication;
            }
        });
    }
}

