/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import com.kiwigrid.helm.maven.plugin.pojo.HelmRepository;
import java.io.File;
import java.net.PasswordAuthentication;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="init", defaultPhase=LifecyclePhase.INITIALIZE)
public class InitMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.init.skipRefresh")
    private boolean skipRefresh;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip init");
            return;
        }
        this.getLog().info((CharSequence)"Initializing Helm...");
        this.getLog().info((CharSequence)"Creating output directory...");
        this.callCli("mkdir -p " + this.getOutputDirectory(), "Unable to create output directory at " + this.getOutputDirectory(), false);
        this.getLog().info((CharSequence)"Downloading Helm...");
        this.callCli("wget -qO " + this.getHelmExecutableDirectory() + File.separator + "helm.tar.gz " + this.getHelmDownloadUrl(), "Unable to download helm", false);
        this.getLog().info((CharSequence)"Unpacking Helm...");
        this.callCli("tar -xf " + this.getHelmExecutableDirectory() + File.separator + "helm.tar.gz --strip=1 --directory=" + this.getHelmExecutableDirectory(), "Unable to unpack helm to " + this.getHelmExecutableDirectory(), false);
        this.getLog().info((CharSequence)"Run helm init...");
        this.callCli(this.getHelmExecutableDirectory() + File.separator + "helm init --client-only" + (this.skipRefresh ? " --skip-refresh" : "") + (StringUtils.isNotEmpty((String)this.getHelmHomeDirectory()) ? " --home=" + this.getHelmHomeDirectory() : ""), "Unable to call helm init", false);
        if (this.getHelmExtraRepos() != null) {
            for (HelmRepository repository : this.getHelmExtraRepos()) {
                this.getLog().info((CharSequence)("Adding repo " + repository));
                PasswordAuthentication auth = this.getAuthentication(repository);
                this.callCli(this.getHelmExecutableDirectory() + File.separator + "helm repo add " + repository.getName() + " " + repository.getUrl() + (StringUtils.isNotEmpty((String)this.getHelmHomeDirectory()) ? " --home=" + this.getHelmHomeDirectory() : "") + (auth != null ? " --username=" + auth.getUserName() + " --password=" + String.valueOf(auth.getPassword()) : ""), "Unable add repo", false);
            }
        }
    }

    public boolean isSkipRefresh() {
        return this.skipRefresh;
    }

    public void setSkipRefresh(boolean skipRefresh) {
        this.skipRefresh = skipRefresh;
    }
}

