/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.pojo.HelmRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.PasswordAuthentication;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractHelmMojo
extends AbstractMojo {
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter(property="helm.executableDirectory", defaultValue="${project.build.directory}/helm")
    private String helmExecutableDirectory;
    @Parameter(property="helm.executable")
    private String helmExecuteable;
    @Parameter(property="helm.outputDirectory", defaultValue="${project.build.directory}/helm/repo")
    private String outputDirectory;
    @Parameter(property="helm.excludes")
    private String[] excludes;
    @Parameter(property="helm.chartDirectory", required=true)
    private String chartDirectory;
    @Parameter(property="helm.chartVersion", required=true)
    private String chartVersion;
    @Parameter(property="helm.appVersion")
    private String appVersion;
    @Parameter(property="helm.uploadRepo.stable")
    private HelmRepository uploadRepoStable;
    @Parameter(property="helm.uploadRepo.snapshot")
    private HelmRepository uploadRepoSnapshot;
    @Parameter(property="helm.downloadUrl")
    private String helmDownloadUrl;
    @Parameter(property="helm.homeDirectory")
    private String helmHomeDirectory;
    @Parameter(property="helm.extraRepos")
    private HelmRepository[] helmExtraRepos;
    @Parameter(property="helm.security", defaultValue="~/.m2/settings-security.xml")
    private String helmSecurity;
    @Parameter(property="helm.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;

    Path getHelmExecuteablePath() throws MojoExecutionException {
        Path path;
        if (this.helmExecuteable == null) {
            String string = this.helmExecuteable = SystemUtils.IS_OS_WINDOWS ? "helm.exe" : "helm";
        }
        if (!(path = Paths.get(this.helmExecutableDirectory, this.helmExecuteable).toAbsolutePath()).toFile().exists()) {
            throw new MojoExecutionException("Helm executeable at " + path + " not found.");
        }
        return path;
    }

    void callCli(String command, String errorMessage, boolean verbose) throws MojoExecutionException {
        int exitValue;
        this.getLog().debug((CharSequence)command);
        try {
            Process p = Runtime.getRuntime().exec(command);
            new Thread(() -> {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String errorLine;
                    String inputLine;
                    while ((inputLine = input.readLine()) != null) {
                        if (verbose) {
                            this.getLog().info((CharSequence)inputLine);
                            continue;
                        }
                        this.getLog().debug((CharSequence)inputLine);
                    }
                    while ((errorLine = error.readLine()) != null) {
                        this.getLog().error((CharSequence)errorLine);
                    }
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }).start();
            p.waitFor();
            exitValue = p.exitValue();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing command [" + command + "]", e);
        }
        if (exitValue != 0) {
            throw new MojoExecutionException(errorMessage);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> getChartDirectories(String path) throws MojoExecutionException {
        try (Stream<Path> files = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            List<String> chartDirs = files.filter(p -> p.getFileName().toString().equalsIgnoreCase("chart.yaml")).map(p -> p.getParent().toString()).collect(Collectors.toList());
            if (chartDirs.isEmpty()) {
                this.getLog().warn((CharSequence)("No Charts detected - no Chart.yaml files found below " + path));
            }
            List<String> list = chartDirs;
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan chart directory at " + path, (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> getChartTgzs(String path) throws MojoExecutionException {
        try (Stream<Path> files = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            List<String> list = files.filter(p -> p.getFileName().toString().endsWith("tgz")).map(Path::toString).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan repo directory at " + path, (Exception)e);
        }
    }

    String getHelmUploadUrl() {
        String uploadUrl = this.uploadRepoStable.getUrl();
        if (this.chartVersion.endsWith("-SNAPSHOT") && this.uploadRepoSnapshot != null && StringUtils.isNotEmpty((CharSequence)this.uploadRepoSnapshot.getUrl())) {
            uploadUrl = this.uploadRepoSnapshot.getUrl();
        }
        return uploadUrl;
    }

    HelmRepository getHelmUploadRepo() {
        if (this.chartVersion.endsWith("-SNAPSHOT") && this.uploadRepoSnapshot != null && StringUtils.isNotEmpty((CharSequence)this.uploadRepoSnapshot.getUrl())) {
            return this.uploadRepoSnapshot;
        }
        return this.uploadRepoStable;
    }

    PasswordAuthentication getAuthentication(HelmRepository repository) throws IllegalArgumentException, MojoExecutionException {
        String id = repository.getName();
        if (repository.getUsername() != null) {
            if (repository.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " has a username but no password defined.");
            }
            this.getLog().debug((CharSequence)("Repo " + id + " has credentials definded, skip searching in server list."));
            return new PasswordAuthentication(repository.getUsername(), repository.getPassword().toCharArray());
        }
        Server server = this.settings.getServer(id);
        if (server == null) {
            this.getLog().info((CharSequence)("No credentials found for " + id + " in configuration or settings.xml server list."));
            return null;
        }
        this.getLog().debug((CharSequence)("Use credentials from server list for " + id + "."));
        if (server.getUsername() == null || server.getPassword() == null) {
            throw new IllegalArgumentException("Repo " + id + " was found in server list but has no username/password.");
        }
        try {
            return new PasswordAuthentication(server.getUsername(), this.getSecDispatcher().decrypt(server.getPassword()).toCharArray());
        }
        catch (SecDispatcherException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected SecDispatcher getSecDispatcher() {
        if (this.securityDispatcher instanceof DefaultSecDispatcher) {
            ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile(this.getHelmSecurity());
        }
        return this.securityDispatcher;
    }

    public String getHelmExecuteable() {
        return this.helmExecuteable;
    }

    public void setHelmExecuteable(String helmExecuteable) {
        this.helmExecuteable = helmExecuteable;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getHelmExecutableDirectory() {
        return this.helmExecutableDirectory;
    }

    public void setHelmExecutableDirectory(String helmExecuteableDirectory) {
        this.helmExecutableDirectory = helmExecuteableDirectory;
    }

    public String getHelmDownloadUrl() {
        return this.helmDownloadUrl;
    }

    public void setHelmDownloadUrl(String helmDownloadUrl) {
        this.helmDownloadUrl = helmDownloadUrl;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String getChartDirectory() {
        return this.chartDirectory;
    }

    public void setChartDirectory(String chartDirectory) {
        this.chartDirectory = chartDirectory;
    }

    public String getHelmHomeDirectory() {
        return this.helmHomeDirectory;
    }

    public void setHelmHomeDirectory(String helmHomeDirectory) {
        this.helmHomeDirectory = helmHomeDirectory;
    }

    public String getChartVersion() {
        return this.chartVersion;
    }

    public void setChartVersion(String chartVersion) {
        this.chartVersion = chartVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public HelmRepository[] getHelmExtraRepos() {
        return this.helmExtraRepos;
    }

    public void setHelmExtraRepos(HelmRepository[] helmExtraRepos) {
        this.helmExtraRepos = helmExtraRepos;
    }

    public HelmRepository getUploadRepoStable() {
        return this.uploadRepoStable;
    }

    public void setUploadRepoStable(HelmRepository uploadRepoStable) {
        this.uploadRepoStable = uploadRepoStable;
    }

    public HelmRepository getUploadRepoSnapshot() {
        return this.uploadRepoSnapshot;
    }

    public void setUploadRepoSnapshot(HelmRepository uploadRepoSnapshot) {
        this.uploadRepoSnapshot = uploadRepoSnapshot;
    }

    public String getHelmSecurity() {
        return this.helmSecurity;
    }

    public void setHelmSecurity(String helmSecurity) {
        this.helmSecurity = helmSecurity;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

