/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import com.kiwigrid.helm.maven.plugin.pojo.HelmRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="init", defaultPhase=LifecyclePhase.INITIALIZE)
public class InitMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.init.skipRefresh", defaultValue="false")
    private boolean skipRefresh;
    @Parameter(property="helm.init.skip", defaultValue="false")
    private boolean skipInit;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipInit) {
            this.getLog().info((CharSequence)"Skip init");
            return;
        }
        this.getLog().info((CharSequence)"Initializing Helm...");
        Path outputDirectory = Paths.get(this.getOutputDirectory(), new String[0]).toAbsolutePath();
        if (!Files.exists(outputDirectory, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Creating output directory...");
            try {
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create output directory at " + outputDirectory, (Exception)e);
            }
        }
        if (this.isUseLocalHelmBinary()) {
            this.verifyLocalHelmBinary();
            this.getLog().info((CharSequence)("Using local HELM binary [" + this.getHelmExecutableDirectory() + "]"));
        } else {
            this.downloadAndUnpackHelm();
        }
        if (this.getHelmExtraRepos() != null) {
            for (HelmRepository repository : this.getHelmExtraRepos()) {
                this.getLog().info((CharSequence)("Adding repo " + repository));
                PasswordAuthentication auth = this.getAuthentication(repository);
                this.callCli(this.getHelmExecutableDirectory() + File.separator + "helm repo add " + repository.getName() + " " + repository.getUrl() + (StringUtils.isNotEmpty((String)this.getHelmHomeDirectory()) ? " --home=" + this.getHelmHomeDirectory() : "") + (auth != null ? " --username=" + auth.getUserName() + " --password=" + String.valueOf(auth.getPassword()) : ""), "Unable add repo", false);
            }
        }
    }

    protected void downloadAndUnpackHelm() throws MojoExecutionException {
        Path directory = Paths.get(this.getHelmExecutableDirectory(), new String[0]);
        if (Files.exists(directory.resolve(SystemUtils.IS_OS_WINDOWS ? "helm.exe" : "helm"), new LinkOption[0])) {
            this.getLog().info((CharSequence)"Found helm executable, skip init.");
            return;
        }
        this.getLog().info((CharSequence)"Downloading Helm ...");
        boolean found = false;
        try (TarArchiveInputStream is = new TarArchiveInputStream((InputStream)new GZIPInputStream(new URL(this.getHelmDownloadUrl()).openStream()));){
            Files.createDirectories(directory, new FileAttribute[0]);
            while (is.getNextEntry() != null) {
                String name = is.getCurrentEntry().getName();
                if (is.getCurrentEntry().isDirectory() || !name.endsWith("helm.exe") && !name.endsWith("helm")) {
                    this.getLog().debug((CharSequence)("Skip archive entry with name: " + name));
                    continue;
                }
                this.getLog().debug((CharSequence)("Use archive entry with name: " + name));
                Path helm = directory.resolve(name.endsWith(".exe") ? "helm.exe" : "helm");
                try (FileOutputStream output = new FileOutputStream(helm.toFile());){
                    IOUtils.copy((InputStream)is, (OutputStream)output);
                }
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(helm, new LinkOption[0]);
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions(helm, permissions);
                found = true;
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to download and extract helm executable.", (Exception)e);
        }
        if (!found) {
            throw new MojoExecutionException("Unable to find helm executable in tar file.");
        }
        this.getLog().info((CharSequence)"Run helm init...");
        this.callCli(this.getHelmExecutableDirectory() + File.separator + "helm init --client-only" + (this.skipRefresh ? " --skip-refresh" : "") + (StringUtils.isNotEmpty((String)this.getHelmHomeDirectory()) ? " --home=" + this.getHelmHomeDirectory() : ""), "Unable to call helm init", false);
    }

    private void verifyLocalHelmBinary() throws MojoExecutionException {
        this.callCli(this.getHelmExecuteablePath() + " version --client", "Unable to verify local HELM binary", false);
    }

    public boolean isSkipRefresh() {
        return this.skipRefresh;
    }

    public void setSkipRefresh(boolean skipRefresh) {
        this.skipRefresh = skipRefresh;
    }
}

