/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.package.skip", defaultValue="false")
    private boolean skipPackage;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipPackage) {
            this.getLog().info((CharSequence)"Skip package");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            if (this.getExcludes() != null && Arrays.asList(this.getExcludes()).contains(inputDirectory)) {
                this.getLog().debug((CharSequence)("Skip excluded directory " + inputDirectory));
                continue;
            }
            this.getLog().info((CharSequence)("Packaging chart " + inputDirectory + "..."));
            String helmCommand = this.getHelmExecuteablePath() + " package " + inputDirectory + " -d " + this.getOutputDirectory() + (StringUtils.isNotEmpty((String)this.getHelmHomeDirectory()) ? " --home=" + this.getHelmHomeDirectory() : "");
            if (this.getChartVersion() != null) {
                this.getLog().info((CharSequence)String.format("Setting chart version to %s", this.getChartVersion()));
                helmCommand = helmCommand + " --version " + this.getChartVersion();
            }
            if (this.getAppVersion() != null) {
                this.getLog().info((CharSequence)String.format("Setting App version to %s", this.getAppVersion()));
                helmCommand = helmCommand + " --app-version " + this.getAppVersion();
            }
            this.callCli(helmCommand, "Unable to package chart at " + inputDirectory, true);
        }
    }
}

