/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmWithValueOverrideMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="template", defaultPhase=LifecyclePhase.TEST)
public class TemplateMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="action", defaultValue="template")
    private String action;
    @Parameter(property="helm.additional.arguments")
    private String additionalArguments;
    @Parameter(property="helm.template.skip", defaultValue="true")
    private boolean skipTemplate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTemplate) {
            this.getLog().info((CharSequence)"Skip template");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)String.format("\n\nPerform template for chart %s...", inputDirectory));
            this.callCli(String.format("%s %s %s %s %s %s %s %s", this.getHelmExecuteablePath(), this.action, inputDirectory, StringUtils.isNotEmpty((String)this.additionalArguments) ? this.additionalArguments : "", this.formatIfValueIsNotEmpty("--registry-config=%s", this.getRegistryConfig()), this.formatIfValueIsNotEmpty("--repository-cache=%s", this.getRepositoryCache()), this.formatIfValueIsNotEmpty("--repository-config=%s", this.getRepositoryConfig()), this.getValuesOptions()), "There are test failures", true);
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

