/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import com.kiwigrid.helm.maven.plugin.exception.BadUploadException;
import com.kiwigrid.helm.maven.plugin.pojo.HelmRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public class UploadMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.upload.skip", defaultValue="false")
    private boolean skipUpload;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipUpload) {
            this.getLog().info((CharSequence)"Skip upload");
            return;
        }
        this.getLog().info((CharSequence)("Uploading to " + this.getHelmUploadUrl() + "\n"));
        for (String chartPackageFile : this.getChartFiles(this.getOutputDirectory())) {
            this.getLog().info((CharSequence)("Uploading " + chartPackageFile + "..."));
            try {
                this.uploadSingle(chartPackageFile);
            }
            catch (BadUploadException | IOException e) {
                this.getLog().error((CharSequence)e.getMessage());
                throw new MojoExecutionException("Error uploading " + chartPackageFile + " to " + this.getHelmUploadUrl(), e);
            }
        }
    }

    protected void uploadSingle(String file) throws IOException, BadUploadException, MojoExecutionException {
        HttpURLConnection connection;
        File fileToUpload = new File(file);
        HelmRepository uploadRepo = this.getHelmUploadRepo();
        if (uploadRepo.getType() == null) {
            throw new IllegalArgumentException("Repository type missing. Check your plugin configuration.");
        }
        switch (uploadRepo.getType()) {
            case ARTIFACTORY: {
                connection = this.getConnectionForUploadToArtifactory(fileToUpload, uploadRepo.isUseGroupId());
                break;
            }
            case CHARTMUSEUM: {
                connection = this.getConnectionForUploadToChartmuseum();
                break;
            }
            case NEXUS: {
                connection = this.getConnectionForUploadToNexus(fileToUpload);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type for upload.");
            }
        }
        try (FileInputStream fileInputStream = new FileInputStream(fileToUpload);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)connection.getOutputStream());
        }
        if (connection.getResponseCode() >= 300) {
            String response = connection.getErrorStream() != null ? IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charset.defaultCharset()) : (connection.getInputStream() != null ? IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset()) : "No details provided");
            throw new BadUploadException(response);
        }
        String message = Integer.toString(connection.getResponseCode());
        if (connection.getInputStream() != null) {
            message = message + " - " + IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset());
        }
        this.getLog().info((CharSequence)message);
        connection.disconnect();
    }

    protected HttpURLConnection getConnectionForUploadToChartmuseum() throws IOException, MojoExecutionException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.getHelmUploadUrl()).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.setBasicAuthHeader(connection);
        return connection;
    }

    private void setBasicAuthHeader(HttpURLConnection connection) throws MojoExecutionException {
        PasswordAuthentication authentication = this.getAuthentication(this.getHelmUploadRepo());
        if (authentication != null) {
            String encoded = Base64.getEncoder().encodeToString((authentication.getUserName() + ":" + new String(authentication.getPassword())).getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + encoded);
        }
    }

    protected HttpURLConnection getConnectionForUploadToArtifactory(File file, boolean useGroupId) throws IOException, MojoExecutionException {
        String uploadUrl = this.getHelmUploadUrl();
        if (!uploadUrl.endsWith("/")) {
            uploadUrl = uploadUrl + "/";
        }
        if (useGroupId) {
            uploadUrl = uploadUrl + this.getProjectGroupId().replace(".", "/") + "/" + this.getProjectVersion() + "/";
        }
        uploadUrl = uploadUrl + file.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.verifyAndSetAuthentication(true);
        return connection;
    }

    protected HttpURLConnection getConnectionForUploadToNexus(File file) throws IOException, MojoExecutionException {
        String uploadUrl = this.getHelmUploadUrl();
        if (!uploadUrl.endsWith("/")) {
            uploadUrl = uploadUrl + "/";
        }
        uploadUrl = uploadUrl + file.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.verifyAndSetAuthentication(false);
        return connection;
    }

    private void verifyAndSetAuthentication(boolean requireCredentials) throws MojoExecutionException {
        final PasswordAuthentication authentication = this.getAuthentication(this.getHelmUploadRepo());
        if (authentication != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return authentication;
                }
            });
        } else if (requireCredentials) {
            throw new IllegalArgumentException("Credentials has to be configured for uploading to Artifactory.");
        }
    }
}

