/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.package.skip", defaultValue="false")
    private boolean skipPackage;
    @Parameter(property="helm.package.keyring")
    private String keyring;
    @Parameter(property="helm.package.key")
    private String key;
    @Parameter(property="helm.package.passphrase")
    private String passphrase;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipPackage) {
            this.getLog().info((CharSequence)"Skip package");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)("Packaging chart " + inputDirectory + "..."));
            String helmCommand = this.getHelmExecuteablePath() + " package " + inputDirectory + " -d " + this.getOutputDirectory() + (StringUtils.isNotEmpty((String)this.getRegistryConfig()) ? " --registry-config=" + this.getRegistryConfig() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryCache()) ? " --repository-cache=" + this.getRepositoryCache() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryConfig()) ? " --repository-config=" + this.getRepositoryConfig() : "");
            if (this.getChartVersion() != null) {
                this.getLog().info((CharSequence)String.format("Setting chart version to %s", this.getChartVersionWithProcessing()));
                helmCommand = helmCommand + " --version " + this.getChartVersionWithProcessing();
            }
            if (this.getAppVersion() != null) {
                this.getLog().info((CharSequence)String.format("Setting App version to %s", this.getAppVersion()));
                helmCommand = helmCommand + " --app-version " + this.getAppVersion();
            }
            String stdin = null;
            if (this.isSignEnabled()) {
                this.getLog().info((CharSequence)"Enable signing");
                helmCommand = helmCommand + " --sign --keyring " + this.keyring + " --key " + this.key;
                if (StringUtils.isNotEmpty((String)this.passphrase)) {
                    helmCommand = helmCommand + " --passphrase-file -";
                    stdin = this.passphrase;
                }
            }
            this.callCli(helmCommand, "Unable to package chart at " + inputDirectory, true, stdin);
        }
    }

    private boolean isSignEnabled() {
        return StringUtils.isNotEmpty((String)this.keyring) && StringUtils.isNotEmpty((String)this.key);
    }
}

