/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import com.kiwigrid.helm.maven.plugin.exception.BadUploadException;
import com.kiwigrid.helm.maven.plugin.pojo.HelmRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public class UploadMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.upload.skip", defaultValue="false")
    private boolean skipUpload;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipUpload) {
            this.getLog().info((CharSequence)"Skip upload");
            return;
        }
        this.getLog().info((CharSequence)("Uploading to " + this.getHelmUploadUrl() + "\n"));
        for (String chartPackageFile : this.getChartTgzs(this.getOutputDirectory())) {
            this.getLog().info((CharSequence)("Uploading " + chartPackageFile + "..."));
            try {
                this.uploadSingle(chartPackageFile);
            }
            catch (BadUploadException | IOException e) {
                this.getLog().error((CharSequence)e.getMessage());
                throw new MojoExecutionException("Error uploading " + chartPackageFile + " to " + this.getHelmUploadUrl(), e);
            }
        }
    }

    protected void uploadSingle(String file) throws IOException, BadUploadException, MojoExecutionException {
        HttpURLConnection connection;
        File fileToUpload = new File(file);
        HelmRepository uploadRepo = this.getHelmUploadRepo();
        if (uploadRepo.getType() == null) {
            throw new IllegalArgumentException("Repository type missing. Check your plugin configuration.");
        }
        switch (uploadRepo.getType()) {
            case ARTIFACTORY: {
                connection = this.getConnectionForUploadToArtifactory(fileToUpload);
                break;
            }
            case CHARTMUSEUM: {
                connection = this.getConnectionForUploadToChartmuseum();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type for upload.");
            }
        }
        try (FileInputStream fileInputStream = new FileInputStream(fileToUpload);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)connection.getOutputStream());
        }
        if (connection.getResponseCode() >= 300) {
            String response = connection.getErrorStream() != null ? IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charset.defaultCharset()) : (connection.getInputStream() != null ? IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset()) : "No details provided");
            throw new BadUploadException(response);
        }
        String message = Integer.toString(connection.getResponseCode());
        if (connection.getInputStream() != null) {
            message = message + " - " + IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset());
        }
        this.getLog().info((CharSequence)message);
        connection.disconnect();
    }

    protected HttpURLConnection getConnectionForUploadToChartmuseum() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.getHelmUploadUrl()).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/gzip");
        HelmRepository helmUploadRepo = this.getHelmUploadRepo();
        if (StringUtils.isNotEmpty((CharSequence)helmUploadRepo.getUsername()) && StringUtils.isNotEmpty((CharSequence)helmUploadRepo.getPassword())) {
            String encoded = Base64.getEncoder().encodeToString((helmUploadRepo.getUsername() + ":" + helmUploadRepo.getPassword()).getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + encoded);
        }
        return connection;
    }

    protected HttpURLConnection getConnectionForUploadToArtifactory(File file) throws IOException, MojoExecutionException {
        String uploadUrl = this.getHelmUploadUrl();
        if (!uploadUrl.endsWith("/")) {
            uploadUrl = uploadUrl + "/";
        }
        uploadUrl = uploadUrl + file.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.verifyAndSetAuthentication();
        return connection;
    }

    private void verifyAndSetAuthentication() throws MojoExecutionException {
        final PasswordAuthentication authentication = this.getAuthentication(this.getHelmUploadRepo());
        if (authentication == null) {
            throw new IllegalArgumentException("Credentials has to be configured for uploading to Artifactory.");
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return authentication;
            }
        });
    }
}

