/*
 * Decompiled with CFR 0.152.
 */
package com.kiwigrid.helm.maven.plugin;

import com.kiwigrid.helm.maven.plugin.AbstractHelmMojo;
import com.kiwigrid.helm.maven.plugin.pojo.HelmRepository;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="init", defaultPhase=LifecyclePhase.INITIALIZE)
public class InitMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.init.skip", defaultValue="false")
    private boolean skipInit;
    @Parameter(property="helm.init.add-default-repo", defaultValue="true")
    private boolean addDefaultRepo;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipInit) {
            this.getLog().info((CharSequence)"Skip init");
            return;
        }
        this.getLog().info((CharSequence)"Initializing Helm...");
        Path outputDirectory = Paths.get(this.getOutputDirectory(), new String[0]).toAbsolutePath();
        if (!outputDirectory.toFile().exists()) {
            this.getLog().info((CharSequence)"Creating output directory...");
            try {
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create output directory at " + outputDirectory, (Exception)e);
            }
        }
        if (this.isUseLocalHelmBinary()) {
            this.verifyLocalHelmBinary();
            this.getLog().info((CharSequence)("Using local HELM binary [" + this.getHelmExecuteablePath() + "]"));
        } else {
            this.downloadAndUnpackHelm();
        }
        if (this.addDefaultRepo) {
            this.getLog().info((CharSequence)"Adding default repo [stable]");
            this.callCli(this.getHelmExecuteablePath() + " repo add stable https://kubernetes-charts.storage.googleapis.com " + (StringUtils.isNotEmpty((String)this.getRegistryConfig()) ? " --registry-config " + this.getRegistryConfig() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryCache()) ? " --repository-cache " + this.getRepositoryCache() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryConfig()) ? " --repository-config " + this.getRepositoryConfig() : ""), "Unable add repo", false);
        }
        if (this.getHelmExtraRepos() != null) {
            for (HelmRepository repository : this.getHelmExtraRepos()) {
                this.getLog().info((CharSequence)("Adding repo [" + repository + "]"));
                PasswordAuthentication auth = this.getAuthentication(repository);
                this.callCli(this.getHelmExecuteablePath() + " repo add " + repository.getName() + " " + repository.getUrl() + (StringUtils.isNotEmpty((String)this.getRegistryConfig()) ? " --registry-config=" + this.getRegistryConfig() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryCache()) ? " --repository-cache=" + this.getRepositoryCache() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryConfig()) ? " --repository-config=" + this.getRepositoryConfig() : "") + (auth != null ? " --username=" + auth.getUserName() + " --password=" + String.valueOf(auth.getPassword()) : ""), "Unable add repo", false);
            }
        }
    }

    protected void downloadAndUnpackHelm() throws MojoExecutionException {
        Path directory = Paths.get(this.getHelmExecutableDirectory(), new String[0]);
        if (Files.exists(directory.resolve(SystemUtils.IS_OS_WINDOWS ? "helm.exe" : "helm"), new LinkOption[0])) {
            this.getLog().info((CharSequence)"Found helm executable, skip init.");
            return;
        }
        String url = this.getHelmDownloadUrl();
        if (StringUtils.isBlank((String)url)) {
            String os = this.getOperatingSystem();
            String architecture = this.getArchitecture();
            String extension = this.getExtension();
            url = String.format("https://get.helm.sh/helm-v%s-%s-%s.%s", this.getHelmVersion(), os, architecture, extension);
        }
        this.getLog().debug((CharSequence)("Downloading Helm: " + url));
        boolean found = false;
        try (InputStream dis = new URL(url).openStream();
             InputStream cis = this.createCompressorInputStream(dis);
             ArchiveInputStream is = this.createArchiverInputStream(cis);){
            Files.createDirectories(directory, new FileAttribute[0]);
            ArchiveEntry entry = null;
            while ((entry = is.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith("helm.exe") && !name.endsWith("helm")) {
                    this.getLog().debug((CharSequence)("Skip archive entry with name: " + name));
                    continue;
                }
                this.getLog().debug((CharSequence)("Use archive entry with name: " + name));
                Path helm = directory.resolve(name.endsWith(".exe") ? "helm.exe" : "helm");
                try (FileOutputStream output = new FileOutputStream(helm.toFile());){
                    IOUtils.copy((InputStream)is, (OutputStream)output);
                }
                this.addExecPermission(helm);
                found = true;
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to download and extract helm executable.", (Exception)e);
        }
        if (!found) {
            throw new MojoExecutionException("Unable to find helm executable in tar file.");
        }
    }

    public boolean isAddDefaultRepo() {
        return this.addDefaultRepo;
    }

    public void setAddDefaultRepo(boolean addDefaultRepo) {
        this.addDefaultRepo = addDefaultRepo;
    }

    private void addExecPermission(Path helm) throws IOException {
        Set<String> fileAttributeView = FileSystems.getDefault().supportedFileAttributeViews();
        if (fileAttributeView.contains("posix")) {
            Set<PosixFilePermission> permissions;
            try {
                permissions = Files.getPosixFilePermissions(helm, new LinkOption[0]);
            }
            catch (UnsupportedOperationException e) {
                this.getLog().debug((CharSequence)"Exec file permission is not set", (Throwable)e);
                return;
            }
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(helm, permissions);
        } else if (fileAttributeView.contains("acl")) {
            String username = System.getProperty("user.name");
            UserPrincipal userPrincipal = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(username);
            AclEntry aclEntry = AclEntry.newBuilder().setPermissions(AclEntryPermission.EXECUTE).setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).build();
            AclFileAttributeView acl = Files.getFileAttributeView(helm, AclFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            List<AclEntry> aclEntries = acl.getAcl();
            aclEntries.add(aclEntry);
            acl.setAcl(aclEntries);
        }
    }

    private void verifyLocalHelmBinary() throws MojoExecutionException {
        this.callCli(this.getHelmExecuteablePath() + " version", "Unable to verify local HELM binary", false);
    }

    private ArchiveInputStream createArchiverInputStream(InputStream is) throws MojoExecutionException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        try {
            ArchiveStreamFactory archiveStreamFactory = new ArchiveStreamFactory();
            return archiveStreamFactory.createArchiveInputStream(is);
        }
        catch (ArchiveException e) {
            throw new MojoExecutionException("Unsupported archive type downloaded", (Exception)((Object)e));
        }
    }

    private InputStream createCompressorInputStream(InputStream is) throws MojoExecutionException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        String compressorType = null;
        try {
            compressorType = CompressorStreamFactory.detect((InputStream)is);
        }
        catch (CompressorException e) {
            this.getLog().debug((CharSequence)"Unknown type of compressed stream", (Throwable)e);
        }
        if (compressorType != null) {
            try {
                CompressorStreamFactory compressorFactory = new CompressorStreamFactory();
                return compressorFactory.createCompressorInputStream(compressorType, is);
            }
            catch (CompressorException e) {
                throw new MojoExecutionException("Unsupported compressor type: " + compressorType);
            }
        }
        return is;
    }

    private String getArchitecture() {
        String architecture = System.getProperty("os.arch").toLowerCase(Locale.US);
        if (architecture.equals("x86_64") || architecture.equals("amd64")) {
            return "amd64";
        }
        if (architecture.equals("x86") || architecture.equals("i386")) {
            return "386";
        }
        if (architecture.contains("arm64")) {
            return "arm64";
        }
        if (architecture.equals("aarch32") || architecture.startsWith("arm")) {
            return "arm";
        }
        if (architecture.contains("ppc64le") || architecture.contains("ppc64") && System.getProperty("sun.cpu.endian").equals("little")) {
            return "ppc64le";
        }
        throw new IllegalStateException("Unsupported architecture: " + architecture);
    }

    private String getExtension() {
        return Os.OS_FAMILY.equals("windows") ? "zip" : "tar.gz";
    }

    private String getOperatingSystem() {
        switch (Os.OS_FAMILY) {
            case "unix": {
                return "linux";
            }
            case "mac": {
                return "darwin";
            }
            case "windows": {
                return "windows";
            }
        }
        throw new IllegalStateException("Unsupported OS: " + Os.OS_FAMILY);
    }
}

