/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.dropwizard.activemq;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kjetland.dropwizard.activemq.ActiveMQBaseExceptionHandler;
import com.kjetland.dropwizard.activemq.ActiveMQConfig;
import com.kjetland.dropwizard.activemq.ActiveMQConfigHolder;
import com.kjetland.dropwizard.activemq.ActiveMQExceptionHandler;
import com.kjetland.dropwizard.activemq.ActiveMQHealthCheck;
import com.kjetland.dropwizard.activemq.ActiveMQPoolConfig;
import com.kjetland.dropwizard.activemq.ActiveMQReceiver;
import com.kjetland.dropwizard.activemq.ActiveMQReceiverHandler;
import com.kjetland.dropwizard.activemq.ActiveMQSender;
import com.kjetland.dropwizard.activemq.ActiveMQSenderFactory;
import com.kjetland.dropwizard.activemq.ActiveMQSenderImpl;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Optional;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQBundle
implements ConfiguredBundle<ActiveMQConfigHolder>,
Managed,
ActiveMQSenderFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String healthCheckName = "ActiveMQ";
    private ActiveMQConnectionFactory realConnectionFactory;
    private PooledConnectionFactory connectionFactory = null;
    private ObjectMapper objectMapper;
    private Environment environment;
    private long shutdownWaitInSeconds;
    private Optional<Integer> defaultTimeToLiveInSeconds;
    public static final ThreadLocal<String> correlationID = new ThreadLocal();

    public ActiveMQBundle() {
    }

    public ActiveMQBundle(String brokerName) {
        this.healthCheckName = String.format("%s_%s", this.healthCheckName, brokerName);
    }

    public void run(ActiveMQConfigHolder configuration, Environment environment) {
        this.init(configuration.getActiveMQ(), environment);
    }

    public void init(ActiveMQConfig activeMQConfig, Environment environment) {
        this.environment = environment;
        String brokerUrl = activeMQConfig.brokerUrl;
        int configuredTTL = activeMQConfig.timeToLiveInSeconds;
        Optional<String> username = Optional.ofNullable(activeMQConfig.brokerUsername);
        Optional<String> password = Optional.ofNullable(activeMQConfig.brokerPassword);
        this.defaultTimeToLiveInSeconds = Optional.ofNullable(configuredTTL > 0 ? Integer.valueOf(configuredTTL) : null);
        this.log.info("Setting up activeMq with brokerUrl {}", (Object)brokerUrl);
        this.log.debug("All activeMQ config: " + activeMQConfig);
        this.realConnectionFactory = new ActiveMQConnectionFactory(brokerUrl);
        this.realConnectionFactory.setTrustedPackages(activeMQConfig.trustedPackages);
        if (username.isPresent() && password.isPresent()) {
            this.realConnectionFactory.setUserName(username.get());
            this.realConnectionFactory.setPassword(password.get());
        }
        this.connectionFactory = new PooledConnectionFactory();
        this.connectionFactory.setConnectionFactory((Object)this.realConnectionFactory);
        this.configurePool(activeMQConfig.pool);
        this.objectMapper = environment.getObjectMapper();
        environment.lifecycle().manage((Managed)this);
        environment.healthChecks().register(this.healthCheckName, (HealthCheck)new ActiveMQHealthCheck((ConnectionFactory)this.realConnectionFactory, activeMQConfig.healthCheckMillisecondsToWait));
        this.shutdownWaitInSeconds = activeMQConfig.shutdownWaitInSeconds;
    }

    private void configurePool(ActiveMQPoolConfig poolConfig) {
        if (poolConfig == null) {
            return;
        }
        if (poolConfig.maxConnections != null) {
            this.connectionFactory.setMaxConnections(poolConfig.maxConnections.intValue());
        }
        if (poolConfig.maximumActiveSessionPerConnection != null) {
            this.connectionFactory.setMaximumActiveSessionPerConnection(poolConfig.maximumActiveSessionPerConnection.intValue());
        }
        if (poolConfig.blockIfSessionPoolIsFull != null) {
            this.connectionFactory.setBlockIfSessionPoolIsFull(poolConfig.blockIfSessionPoolIsFull.booleanValue());
        }
        if (poolConfig.idleTimeoutMills != null) {
            this.connectionFactory.setIdleTimeout(poolConfig.idleTimeoutMills.intValue());
        }
        if (poolConfig.expiryTimeoutMills != null) {
            this.connectionFactory.setExpiryTimeout(poolConfig.expiryTimeoutMills.longValue());
        }
        if (poolConfig.createConnectionOnStartup != null) {
            this.connectionFactory.setCreateConnectionOnStartup(poolConfig.createConnectionOnStartup.booleanValue());
        }
        if (poolConfig.timeBetweenExpirationCheckMillis != null) {
            this.connectionFactory.setTimeBetweenExpirationCheckMillis(poolConfig.timeBetweenExpirationCheckMillis.longValue());
        }
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void start() {
        this.log.info("Starting activeMQ client");
        this.connectionFactory.start();
    }

    public void stop() {
        this.log.info("Stopping activeMQ client");
        this.connectionFactory.stop();
    }

    @Override
    public ActiveMQSender createSender(String destination, boolean persistent) {
        return this.createSender(destination, persistent, this.defaultTimeToLiveInSeconds);
    }

    @Override
    public ActiveMQSender createSender(String destination, boolean persistent, Optional<Integer> timeToLiveInSeconds) {
        return new ActiveMQSenderImpl((ConnectionFactory)this.connectionFactory, this.objectMapper, destination, timeToLiveInSeconds, persistent);
    }

    public <T> void registerReceiver(String destination, ActiveMQReceiver<T> receiver, Class<? extends T> clazz, boolean ackMessageOnException) {
        ActiveMQReceiverHandler<? extends T> handler = new ActiveMQReceiverHandler<T>(destination, (ConnectionFactory)this.realConnectionFactory, receiver, clazz, this.objectMapper, (message, exception) -> {
            if (ackMessageOnException) {
                this.log.error("Error processing received message - acknowledging it anyway", (Throwable)exception);
                return true;
            }
            this.log.error("Error processing received message - NOT acknowledging it", (Throwable)exception);
            return false;
        }, this.shutdownWaitInSeconds);
        this.internalRegisterReceiver(destination, handler);
    }

    private <T> void internalRegisterReceiver(String destination, ActiveMQReceiverHandler<T> handler) {
        this.environment.lifecycle().manage(handler);
        this.environment.healthChecks().register("ActiveMQ receiver for " + destination, handler.getHealthCheck());
    }

    public <T> void registerReceiver(String destination, ActiveMQReceiver<T> receiver, Class<? extends T> clazz, ActiveMQBaseExceptionHandler exceptionHandler) {
        ActiveMQReceiverHandler<? extends T> handler = new ActiveMQReceiverHandler<T>(destination, (ConnectionFactory)this.realConnectionFactory, receiver, clazz, this.objectMapper, exceptionHandler, this.shutdownWaitInSeconds);
        this.internalRegisterReceiver(destination, handler);
    }

    public <T> void registerReceiver(String destination, ActiveMQReceiver<T> receiver, Class<? extends T> clazz, ActiveMQExceptionHandler exceptionHandler) {
        this.registerReceiver(destination, receiver, clazz, (ActiveMQBaseExceptionHandler)exceptionHandler);
    }
}

