/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.dropwizard.activemq;

import com.google.common.collect.Maps;
import com.kjetland.dropwizard.activemq.ActiveMQBundle;
import com.kjetland.dropwizard.activemq.ActiveMQConfig;
import com.kjetland.dropwizard.activemq.ActiveMQMultiConfigHolder;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Map;

public class ActiveMQMultiBundle
implements ConfiguredBundle<ActiveMQMultiConfigHolder> {
    private Map<String, ActiveMQBundle> activeMQBundleMap;

    public void run(ActiveMQMultiConfigHolder configuration, Environment environment) throws Exception {
        this.activeMQBundleMap = Maps.transformEntries(configuration.getActiveMQConnections(), (brokerName, activeMQConfig) -> {
            ActiveMQBundle activeMQBundle = new ActiveMQBundle((String)brokerName);
            activeMQBundle.init((ActiveMQConfig)activeMQConfig, environment);
            return activeMQBundle;
        });
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public Map<String, ActiveMQBundle> getActiveMQBundleMap() {
        return this.activeMQBundleMap;
    }
}

