/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.dropwizard.activemq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kjetland.dropwizard.activemq.ActiveMQBundle;
import com.kjetland.dropwizard.activemq.ActiveMQSender;
import com.kjetland.dropwizard.activemq.ActiveMQUtils;
import com.kjetland.dropwizard.activemq.DestinationCreator;
import com.kjetland.dropwizard.activemq.DestinationCreatorImpl;
import com.kjetland.dropwizard.activemq.JMSFunction;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQSenderImpl
implements ActiveMQSender {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionFactory connectionFactory;
    private final ObjectMapper objectMapper;
    private final String destination;
    private final Optional<Integer> timeToLiveInSeconds;
    private final boolean persistent;
    protected final DestinationCreator destinationCreator = new DestinationCreatorImpl();

    public ActiveMQSenderImpl(ConnectionFactory connectionFactory, ObjectMapper objectMapper, String destination, Optional<Integer> timeToLiveInSeconds, boolean persistent) {
        this.connectionFactory = connectionFactory;
        this.objectMapper = objectMapper;
        this.destination = destination;
        this.timeToLiveInSeconds = timeToLiveInSeconds;
        this.persistent = persistent;
    }

    @Override
    public void send(Object object) {
        try {
            String json = this.objectMapper.writeValueAsString(object);
            this.internalSend(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending to jms", e);
        }
    }

    @Override
    public void sendJson(String json) {
        try {
            this.internalSend(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending to jms", e);
        }
    }

    private void internalSend(String json) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending to {}: {}", (Object)this.destination, (Object)json);
        }
        this.internalSend((Session session) -> {
            TextMessage textMessage = session.createTextMessage(json);
            textMessage.setText(json);
            String correlationId = ActiveMQBundle.correlationID.get();
            if (textMessage.getJMSCorrelationID() == null && correlationId != null) {
                textMessage.setJMSCorrelationID(correlationId);
            }
            return textMessage;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSend(JMSFunction<Session, Message> messageCreator) throws JMSException {
        Connection connection = this.connectionFactory.createConnection();
        try {
            Session session = connection.createSession(false, 1);
            try {
                Destination d = this.destinationCreator.create(session, this.destination);
                MessageProducer messageProducer = session.createProducer(d);
                try {
                    messageProducer.setDeliveryMode(this.persistent ? 2 : 1);
                    if (this.timeToLiveInSeconds.isPresent()) {
                        messageProducer.setTimeToLive(TimeUnit.SECONDS.toMillis(this.timeToLiveInSeconds.get().intValue()));
                    }
                    Message message = messageCreator.apply(session);
                    messageProducer.send(message);
                }
                finally {
                    ActiveMQUtils.silent(() -> messageProducer.close());
                }
            }
            finally {
                ActiveMQUtils.silent(() -> session.close());
            }
        }
        finally {
            ActiveMQUtils.silent(() -> connection.close());
        }
    }

    @Override
    public void send(JMSFunction<Session, Message> messageCreator) {
        try {
            this.internalSend(messageCreator);
        }
        catch (JMSException jmsException) {
            throw new RuntimeException("Error sending to jms", jmsException);
        }
    }
}

