/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.Resources;
import com.klarna.hiverunner.HiveServerContainer;
import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.HiveShellContainer;
import com.klarna.hiverunner.StandaloneHiveServerContext;
import com.klarna.hiverunner.ThrowOnTimeout;
import com.klarna.hiverunner.TimeoutException;
import com.klarna.hiverunner.annotations.HiveProperties;
import com.klarna.hiverunner.annotations.HiveResource;
import com.klarna.hiverunner.annotations.HiveRunnerSetup;
import com.klarna.hiverunner.annotations.HiveSQL;
import com.klarna.hiverunner.annotations.HiveSetupScript;
import com.klarna.hiverunner.builder.HiveShellBuilder;
import com.klarna.hiverunner.config.HiveRunnerConfig;
import com.klarna.reflection.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class StandaloneHiveRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneHiveRunner.class);
    private HiveShellContainer container;
    private HiveRunnerConfig config = new HiveRunnerConfig();

    public StandaloneHiveRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected List<TestRule> getTestRules(final Object target) {
        final TemporaryFolder testBaseDir = new TemporaryFolder();
        TestRule hiveRunnerRule = new TestRule(){

            public Statement apply(final Statement base, Description description) {
                Statement statement = new Statement(){

                    public void evaluate() throws Throwable {
                        StandaloneHiveRunner.this.evaluateStatement(target, testBaseDir, base);
                    }
                };
                return statement;
            }
        };
        ArrayList<TestRule> rules = new ArrayList<TestRule>();
        rules.addAll(super.getTestRules(target));
        rules.add(hiveRunnerRule);
        rules.add((TestRule)testBaseDir);
        rules.add(ThrowOnTimeout.create(this.config, this.getName()));
        rules.add(this.getHiveRunnerConfigRule(target));
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            this.setLogContext(method);
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            try {
                this.runTestMethod(method, eachNotifier, this.config.getTimeoutRetries());
            }
            finally {
                eachNotifier.fireTestFinished();
                this.clearLogContext();
            }
        }
    }

    protected final void runTestMethod(FrameworkMethod method, EachTestNotifier notifier, int retriesLeft) {
        Statement statement = this.methodBlock(method);
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            notifier.addFailedAssumption(e);
        }
        catch (TimeoutException e) {
            if (--retriesLeft >= 0) {
                LOGGER.warn("Test case timed out. Will attempt retry {} more times. Turn on log level DEBUG for stacktrace", (Object)retriesLeft);
                LOGGER.debug(e.getMessage(), (Throwable)e);
                this.tearDown();
                this.runTestMethod(method, notifier, retriesLeft);
            } else {
                notifier.addFailure((Throwable)e);
            }
        }
        catch (Throwable e) {
            notifier.addFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateStatement(Object target, TemporaryFolder temporaryFolder, Statement base) throws Throwable {
        this.container = null;
        FileUtil.setPermission((File)temporaryFolder.getRoot(), (FsPermission)FsPermission.getDirDefault());
        try {
            LOGGER.info("Setting up {} in {}", (Object)this.getName(), (Object)temporaryFolder.getRoot().getAbsolutePath());
            this.container = this.createHiveServerContainer(target, temporaryFolder);
            base.evaluate();
        }
        finally {
            this.tearDown();
        }
    }

    private void tearDown() {
        if (this.container != null) {
            LOGGER.info("Tearing down {}", (Object)this.getName());
            try {
                this.container.tearDown();
            }
            catch (Throwable e) {
                LOGGER.warn("Tear down failed: " + e.getMessage(), e);
            }
        }
    }

    private HiveShellContainer createHiveServerContainer(Object testCase, TemporaryFolder baseDir) throws IOException {
        StandaloneHiveServerContext context = new StandaloneHiveServerContext(baseDir, this.config);
        HiveServerContainer hiveTestHarness = new HiveServerContainer(context);
        HiveShellBuilder hiveShellBuilder = new HiveShellBuilder();
        hiveShellBuilder.setCommandShellEmulation(this.config.getCommandShellEmulator());
        HiveShellField shellSetter = this.loadScriptUnderTest(testCase, hiveShellBuilder);
        hiveShellBuilder.setHiveServerContainer(hiveTestHarness);
        this.loadAnnotatedResources(testCase, hiveShellBuilder);
        this.loadAnnotatedProperties(testCase, hiveShellBuilder);
        this.loadAnnotatedSetupScripts(testCase, hiveShellBuilder);
        HiveShellContainer shell = hiveShellBuilder.buildShell();
        shellSetter.setShell(shell);
        if (shellSetter.isAutoStart()) {
            shell.start();
        }
        return shell;
    }

    private HiveShellField loadScriptUnderTest(final Object testCaseInstance, HiveShellBuilder hiveShellBuilder) {
        try {
            Set<Field> fields = ReflectionUtils.getAllFields(testCaseInstance.getClass(), (Predicate<? super Field>)org.reflections.ReflectionUtils.withAnnotation(HiveSQL.class));
            Preconditions.checkState((fields.size() == 1 ? 1 : 0) != 0, (Object)"Exact one field should to be annotated with @HiveSQL");
            final Field field = fields.iterator().next();
            ArrayList<Path> scripts = new ArrayList<Path>();
            HiveSQL annotation = field.getAnnotation(HiveSQL.class);
            for (String scriptFilePath : annotation.files()) {
                Path file = Paths.get(Resources.getResource((String)scriptFilePath).toURI());
                this.assertFileExists(file);
                scripts.add(file);
            }
            Charset charset = annotation.encoding().equals("") ? Charset.defaultCharset() : Charset.forName(annotation.encoding());
            final boolean isAutoStart = annotation.autoStart();
            hiveShellBuilder.setScriptsUnderTest(scripts, charset);
            return new HiveShellField(){

                @Override
                public void setShell(HiveShell shell) {
                    ReflectionUtils.setField(testCaseInstance, field.getName(), shell);
                }

                @Override
                public boolean isAutoStart() {
                    return isAutoStart;
                }
            };
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to init field annotated with @HiveSQL: " + t.getMessage(), t);
        }
    }

    private void assertFileExists(Path file) {
        Preconditions.checkState((boolean)Files.exists(file, new LinkOption[0]), (Object)("File " + file + " does not exist"));
    }

    private void loadAnnotatedSetupScripts(Object testCase, HiveShellBuilder workFlowBuilder) {
        Set<Field> setupScriptFields = ReflectionUtils.getAllFields(testCase.getClass(), (Predicate<? super Field>)org.reflections.ReflectionUtils.withAnnotation(HiveSetupScript.class));
        for (Field setupScriptField : setupScriptFields) {
            if (ReflectionUtils.isOfType(setupScriptField, String.class)) {
                String script = ReflectionUtils.getFieldValue(testCase, setupScriptField.getName(), String.class);
                workFlowBuilder.addSetupScript(script);
                continue;
            }
            if (ReflectionUtils.isOfType(setupScriptField, File.class) || ReflectionUtils.isOfType(setupScriptField, Path.class)) {
                Path path = this.getMandatoryPathFromField(testCase, setupScriptField);
                workFlowBuilder.addSetupScript(StandaloneHiveRunner.readAll(path));
                continue;
            }
            throw new IllegalArgumentException("Field annotated with @HiveSetupScript currently only supports type String, File and Path");
        }
    }

    private static String readAll(Path path) {
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + path + ": " + e.getMessage(), e);
        }
    }

    private void loadAnnotatedResources(Object testCase, HiveShellBuilder workFlowBuilder) throws IOException {
        Set<Field> fields = ReflectionUtils.getAllFields(testCase.getClass(), (Predicate<? super Field>)org.reflections.ReflectionUtils.withAnnotation(HiveResource.class));
        for (Field resourceField : fields) {
            HiveResource annotation = resourceField.getAnnotation(HiveResource.class);
            String targetFile = annotation.targetFile();
            if (ReflectionUtils.isOfType(resourceField, String.class)) {
                String data = ReflectionUtils.getFieldValue(testCase, resourceField.getName(), String.class);
                workFlowBuilder.addResource(targetFile, data);
                continue;
            }
            if (ReflectionUtils.isOfType(resourceField, File.class) || ReflectionUtils.isOfType(resourceField, Path.class)) {
                Path dataFile = this.getMandatoryPathFromField(testCase, resourceField);
                workFlowBuilder.addResource(targetFile, dataFile);
                continue;
            }
            throw new IllegalArgumentException("Fields annotated with @HiveResource currently only supports field type String, File or Path");
        }
    }

    private Path getMandatoryPathFromField(Object testCase, Field resourceField) {
        Path path;
        if (ReflectionUtils.isOfType(resourceField, File.class)) {
            File dataFile = ReflectionUtils.getFieldValue(testCase, resourceField.getName(), File.class);
            path = Paths.get(dataFile.toURI());
        } else if (ReflectionUtils.isOfType(resourceField, Path.class)) {
            path = ReflectionUtils.getFieldValue(testCase, resourceField.getName(), Path.class);
        } else {
            throw new IllegalArgumentException("Only Path or File type is allowed on annotated field " + resourceField);
        }
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File %s does not exist", (Object[])new Object[]{path});
        return path;
    }

    private void loadAnnotatedProperties(Object testCase, HiveShellBuilder workFlowBuilder) {
        for (Field hivePropertyField : ReflectionUtils.getAllFields(testCase.getClass(), (Predicate<? super Field>)org.reflections.ReflectionUtils.withAnnotation(HiveProperties.class))) {
            Preconditions.checkState((boolean)ReflectionUtils.isOfType(hivePropertyField, Map.class), (Object)"Field annotated with @HiveProperties should be of type Map<String, String>");
            workFlowBuilder.putAllProperties(ReflectionUtils.getFieldValue(testCase, hivePropertyField.getName(), Map.class));
        }
    }

    private TestRule getHiveRunnerConfigRule(final Object target) {
        return new TestRule(){

            public Statement apply(Statement base, Description description) {
                Set<Field> fields = ReflectionUtils.getAllFields(target.getClass(), (Predicate<? super Field>)Predicates.and((Predicate)org.reflections.ReflectionUtils.withAnnotation(HiveRunnerSetup.class), (Predicate)org.reflections.ReflectionUtils.withType(HiveRunnerConfig.class)));
                Preconditions.checkState((fields.size() <= 1 ? 1 : 0) != 0, (Object)"Exact one field of type HiveRunnerConfig should to be annotated with @HiveRunnerSetup");
                if (!fields.isEmpty()) {
                    StandaloneHiveRunner.this.config.override(ReflectionUtils.getFieldValue(target, fields.iterator().next().getName(), HiveRunnerConfig.class));
                }
                return base;
            }
        };
    }

    private void clearLogContext() {
        MDC.clear();
    }

    private void setLogContext(FrameworkMethod method) {
        MDC.put((String)"testClassShort", (String)this.getTestClass().getJavaClass().getSimpleName());
        MDC.put((String)"testClass", (String)this.getTestClass().getJavaClass().getName());
        MDC.put((String)"testMethod", (String)method.getName());
    }

    static interface HiveShellField {
        public void setShell(HiveShell var1);

        public boolean isAutoStart();
    }
}

