/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.builder;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.klarna.hiverunner.HiveServerContainer;
import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.builder.HiveResource;
import com.klarna.hiverunner.data.InsertIntoTable;
import com.klarna.hiverunner.sql.StatementLexer;
import com.klarna.hiverunner.sql.cli.CommandShellEmulator;
import com.klarna.hiverunner.sql.split.StatementSplitter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveShellBase
implements HiveShell {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveShellBase.class);
    private static final String DEFAULT_NULL_REPRESENTATION = "NULL";
    private static final String DEFAULT_ROW_VALUE_DELIMTER = "\t";
    protected boolean started = false;
    protected final HiveServerContainer hiveServerContainer;
    protected final Map<String, String> hiveConf;
    protected final Map<String, String> hiveVars;
    protected final List<String> setupScripts;
    protected final List<HiveResource> resources;
    protected final List<String> scriptsUnderTest;
    protected final CommandShellEmulator commandShellEmulator;
    protected StatementLexer lexer;
    protected Path cwd;

    HiveShellBase(HiveServerContainer hiveServerContainer, Map<String, String> hiveConf, List<String> setupScripts, List<HiveResource> resources, List<String> scriptsUnderTest, CommandShellEmulator commandShellEmulator) {
        this.hiveServerContainer = hiveServerContainer;
        this.hiveConf = hiveConf;
        this.commandShellEmulator = commandShellEmulator;
        this.setupScripts = new ArrayList<String>(setupScripts);
        this.resources = new ArrayList<HiveResource>(resources);
        this.scriptsUnderTest = new ArrayList<String>(scriptsUnderTest);
        this.hiveVars = new HashMap<String, String>();
        this.cwd = Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    @Override
    public List<String> executeQuery(String hiveSql) {
        return this.executeQuery(hiveSql, DEFAULT_ROW_VALUE_DELIMTER, DEFAULT_NULL_REPRESENTATION);
    }

    @Override
    public List<String> executeQuery(String hiveSql, String rowValuesDelimitedBy, String replaceNullWith) {
        this.assertStarted();
        List<Object[]> resultSet = this.executeStatement(hiveSql);
        ArrayList<String> result = new ArrayList<String>();
        for (Object[] objects : resultSet) {
            result.add(Joiner.on((String)rowValuesDelimitedBy).useForNull(replaceNullWith).join(objects));
        }
        return result;
    }

    @Override
    public List<Object[]> executeStatement(String hiveSql) {
        this.assertStarted();
        return this.executeStatementWithCommandShellEmulation(hiveSql);
    }

    private void executeScriptWithCommandShellEmulation(String script) {
        List<String> statements = this.lexer.applyToScript(script);
        this.executeStatementsWithCommandShellEmulation(statements);
    }

    private List<Object[]> executeStatementWithCommandShellEmulation(String statement) {
        List<String> statements = this.lexer.applyToStatement(statement);
        return this.executeStatementsWithCommandShellEmulation(statements);
    }

    private List<Object[]> executeStatementsWithCommandShellEmulation(List<String> hiveSqlStatements) {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (String hiveSqlStatement : hiveSqlStatements) {
            results.addAll(this.hiveServerContainer.executeStatement(hiveSqlStatement));
        }
        return results;
    }

    @Override
    public void execute(String hiveSql) {
        this.assertStarted();
        this.executeScriptWithCommandShellEmulation(hiveSql);
    }

    @Override
    public void execute(File file) {
        this.assertStarted();
        this.execute(Charset.defaultCharset(), file);
    }

    @Override
    public void execute(Path path) {
        this.assertStarted();
        this.execute(Charset.defaultCharset(), path);
    }

    @Override
    public void execute(Charset charset, File file) {
        this.assertStarted();
        this.execute(charset, Paths.get(file.toURI()));
    }

    @Override
    public void execute(Charset charset, Path path) {
        this.assertStarted();
        this.assertFileExists(path);
        List<String> hiveSqlStatements = this.lexer.applyToPath(path);
        this.executeStatementsWithCommandShellEmulation(hiveSqlStatements);
    }

    @Override
    public void start() {
        this.assertNotStarted();
        this.started = true;
        this.lexer = new StatementLexer(this.cwd, Charset.defaultCharset(), this.commandShellEmulator);
        this.hiveServerContainer.init(this.hiveConf, this.hiveVars);
        this.executeSetupScripts();
        this.prepareResources();
        this.executeScriptsUnderTest();
    }

    @Override
    public void addSetupScript(String script) {
        this.assertNotStarted();
        this.setupScripts.add(script);
    }

    @Override
    public void addSetupScripts(Charset charset, Path ... scripts) {
        this.assertNotStarted();
        for (Path script : scripts) {
            this.assertFileExists(script);
            try {
                String join = new String(Files.readAllBytes(script), charset);
                this.setupScripts.add(join);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read setup script file '" + script + "': " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void addSetupScripts(Charset charset, File ... scripts) {
        Path[] paths = new Path[scripts.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = Paths.get(scripts[i].toURI());
        }
        this.addSetupScripts(charset, paths);
    }

    @Override
    public void addSetupScripts(File ... scripts) {
        this.addSetupScripts(Charset.defaultCharset(), scripts);
    }

    @Override
    public void addSetupScripts(Path ... scripts) {
        this.addSetupScripts(Charset.defaultCharset(), scripts);
    }

    @Override
    public TemporaryFolder getBaseDir() {
        return this.hiveServerContainer.getBaseDir();
    }

    @Override
    public String expandVariableSubstitutes(String expression) {
        this.assertStarted();
        HiveConf hiveConf = this.getHiveConf();
        Preconditions.checkNotNull((Object)hiveConf);
        return this.hiveServerContainer.getVariableSubstitution().substitute(hiveConf, expression);
    }

    @Override
    public void setProperty(String key, String value) {
        this.setHiveConfValue(key, value);
    }

    @Override
    public void setHiveConfValue(String key, String value) {
        this.assertNotStarted();
        this.hiveConf.put(key, value);
    }

    @Override
    public HiveConf getHiveConf() {
        this.assertStarted();
        return this.hiveServerContainer.getHiveConf();
    }

    @Override
    public OutputStream getResourceOutputStream(String targetFile) {
        try {
            this.assertNotStarted();
            HiveResource resource = new HiveResource(targetFile);
            this.resources.add(resource);
            OutputStream hiveShellStateAwareOutputStream = this.createPreStartOutputStream(resource.getOutputStream());
            return hiveShellStateAwareOutputStream;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void setHiveVarValue(String var, String value) {
        this.assertNotStarted();
        this.hiveVars.put(var, value);
    }

    @Override
    public void addResource(String targetFile, String data) {
        try {
            this.assertNotStarted();
            this.resources.add(new HiveResource(targetFile, data));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void addResource(String targetFile, Path sourceFile) {
        try {
            this.assertNotStarted();
            this.assertFileExists(sourceFile);
            this.resources.add(new HiveResource(targetFile, sourceFile));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void addResource(String targetFile, File sourceFile) {
        this.addResource(targetFile, Paths.get(sourceFile.toURI()));
    }

    @Override
    public InsertIntoTable insertInto(String databaseName, String tableName) {
        this.assertStarted();
        return InsertIntoTable.newInstance(databaseName, tableName, this.getHiveConf());
    }

    private void executeSetupScripts() {
        for (String setupScript : this.setupScripts) {
            LOGGER.debug("Executing script: " + setupScript);
            this.executeScriptWithCommandShellEmulation(setupScript);
        }
    }

    private void prepareResources() {
        for (HiveResource resource : this.resources) {
            String expandedPath = this.hiveServerContainer.expandVariableSubstitutes(resource.getTargetFile());
            this.assertResourcePreconditions(resource, expandedPath);
            Path targetFile = Paths.get(expandedPath, new String[0]);
            try {
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                OutputStream targetFileOutputStream = Files.newOutputStream(targetFile, StandardOpenOption.CREATE_NEW);
                targetFileOutputStream.write(resource.getOutputStream().toByteArray());
                resource.getOutputStream().close();
                targetFileOutputStream.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create resource target file: " + targetFile + " (" + resource.getTargetFile() + "): " + e.getMessage(), e);
            }
            LOGGER.debug("Created hive resource " + targetFile);
        }
    }

    private void executeScriptsUnderTest() {
        for (String script : this.scriptsUnderTest) {
            try {
                this.executeScriptWithCommandShellEmulation(script);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to executeScript '" + script + "': " + e.getMessage(), e);
            }
        }
    }

    protected final void assertResourcePreconditions(HiveResource resource, String expandedPath) {
        String unexpandedPropertyPattern = ".*\\$\\{.*\\}.*";
        boolean isUnexpanded = !expandedPath.matches(unexpandedPropertyPattern);
        Preconditions.checkArgument((boolean)isUnexpanded, (String)"File path %s contains unresolved references. Original arg was: %s", (Object[])new Object[]{expandedPath, resource.getTargetFile()});
        boolean isTargetFileWithinTestDir = expandedPath.startsWith(this.hiveServerContainer.getBaseDir().getRoot().getAbsolutePath());
        Preconditions.checkArgument((boolean)isTargetFileWithinTestDir, (String)"All resource target files should be created in a subdirectory to the test case basedir %s : %s", (Object[])new Object[]{this.hiveServerContainer.getBaseDir().getRoot().getAbsolutePath(), resource.getTargetFile()});
    }

    protected final void assertFileExists(Path file) {
        Preconditions.checkNotNull((Object)file, (Object)"File argument is null");
        Preconditions.checkArgument((boolean)Files.exists(file, new LinkOption[0]), (String)"File %s does not exist", (Object[])new Object[]{file});
        Preconditions.checkArgument((boolean)Files.isRegularFile(file, new LinkOption[0]), (String)"%s is not a file", (Object[])new Object[]{file});
    }

    protected final void assertNotStarted() {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"HiveShell was already started");
    }

    protected final void assertStarted() {
        Preconditions.checkState((boolean)this.started, (Object)"HiveShell was not started");
    }

    private OutputStream createPreStartOutputStream(final ByteArrayOutputStream resourceOutputStream) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                HiveShellBase.this.assertNotStarted();
                resourceOutputStream.write(b);
            }
        };
    }

    @Override
    public List<String> executeQuery(File script) {
        return this.executeQuery(Charset.defaultCharset(), script);
    }

    @Override
    public List<String> executeQuery(Path script) {
        return this.executeQuery(Charset.defaultCharset(), script);
    }

    @Override
    public List<String> executeQuery(Charset charset, File script) {
        return this.executeQuery(charset, script, DEFAULT_ROW_VALUE_DELIMTER, DEFAULT_NULL_REPRESENTATION);
    }

    @Override
    public List<String> executeQuery(Charset charset, Path script) {
        return this.executeQuery(charset, script, DEFAULT_ROW_VALUE_DELIMTER, DEFAULT_NULL_REPRESENTATION);
    }

    @Override
    public List<String> executeQuery(File script, String rowValuesDelimitedBy, String replaceNullWith) {
        return this.executeQuery(Charset.defaultCharset(), script, rowValuesDelimitedBy, replaceNullWith);
    }

    @Override
    public List<String> executeQuery(Path script, String rowValuesDelimitedBy, String replaceNullWith) {
        return this.executeQuery(Charset.defaultCharset(), script, rowValuesDelimitedBy, replaceNullWith);
    }

    @Override
    public List<String> executeQuery(Charset charset, File script, String rowValuesDelimitedBy, String replaceNullWith) {
        return this.executeQuery(charset, Paths.get(script.toURI()), rowValuesDelimitedBy, replaceNullWith);
    }

    @Override
    public List<String> executeQuery(Charset charset, Path script, String rowValuesDelimitedBy, String replaceNullWith) {
        this.assertStarted();
        this.assertFileExists(script);
        try {
            String statements = new String(Files.readAllBytes(script), charset);
            List<String> splitStatements = new StatementSplitter(this.commandShellEmulator).split(statements);
            if (splitStatements.size() != 1) {
                throw new IllegalArgumentException("Script '" + script + "' must contain a single valid statement.");
            }
            String statement = splitStatements.get(0);
            return this.executeQuery(statement, rowValuesDelimitedBy, replaceNullWith);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read setup script file '" + script + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void setCwd(Path cwd) {
        this.assertNotStarted();
        this.cwd = cwd;
    }

    @Override
    public Path getCwd() {
        return this.cwd;
    }
}

