/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.transfer.DataTransferFactory;
import org.apache.hive.hcatalog.data.transfer.HCatWriter;
import org.apache.hive.hcatalog.data.transfer.WriteEntity;
import org.apache.hive.hcatalog.data.transfer.WriterContext;

class TableDataInserter {
    private final String databaseName;
    private final String tableName;
    private final Map<String, String> config;

    TableDataInserter(String databaseName, String tableName, HiveConf conf) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.config = Maps.fromProperties((Properties)conf.getAllProperties());
    }

    void insert(Multimap<Map<String, String>, HCatRecord> data) {
        for (Map partitionSpec : data.keySet()) {
            this.insert(partitionSpec, data.get((Object)partitionSpec));
        }
    }

    private void insert(Map<String, String> partitionSpec, Iterable<HCatRecord> rows) {
        WriteEntity entity = new WriteEntity.Builder().withDatabase(this.databaseName).withTable(this.tableName).withPartition(partitionSpec).build();
        try {
            HCatWriter master = DataTransferFactory.getHCatWriter((WriteEntity)entity, this.config);
            WriterContext context = master.prepareWrite();
            HCatWriter writer = DataTransferFactory.getHCatWriter((WriterContext)context);
            writer.write(rows.iterator());
            master.commit(context);
        }
        catch (HCatException e) {
            throw new RuntimeException("An error occurred while inserting data to " + this.databaseName + "." + this.tableName, e);
        }
    }
}

