/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.sql;

import com.klarna.hiverunner.sql.cli.CommandShellEmulator;
import com.klarna.hiverunner.sql.split.StatementSplitter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class StatementLexer {
    private final Charset charset;
    private final CommandShellEmulator commandShellEmulation;
    private final Path cwd;

    public StatementLexer(Path cwd, Charset charset, CommandShellEmulator commandShellEmulation) {
        this.cwd = cwd;
        this.charset = charset;
        this.commandShellEmulation = commandShellEmulation;
    }

    private List<String> internalApplyToStatement(String statement) {
        String transformedHiveSql = this.commandShellEmulation.preProcessor().statement(statement);
        return this.commandShellEmulation.postProcessor(this).statement(transformedHiveSql);
    }

    public List<String> applyToScript(String script) {
        ArrayList<String> hiveSqlStatements = new ArrayList<String>();
        List<String> statements = new StatementSplitter(this.commandShellEmulation).split(this.commandShellEmulation.preProcessor().script(script));
        for (String statement : statements) {
            hiveSqlStatements.addAll(this.internalApplyToStatement(statement));
        }
        return hiveSqlStatements;
    }

    public List<String> applyToStatement(String statement) {
        return this.internalApplyToStatement(statement);
    }

    public List<String> applyToPath(Path path) {
        if (!path.isAbsolute()) {
            path = this.cwd.resolve(path);
        }
        try {
            String script = new String(Files.readAllBytes(path), this.charset);
            return this.applyToScript(script);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read script file '" + path + "': " + e.getMessage(), e);
        }
    }
}

