/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.klarna.hiverunner.HiveRunnerCore;
import com.klarna.hiverunner.HiveShellContainer;
import com.klarna.hiverunner.annotations.HiveRunnerSetup;
import com.klarna.hiverunner.builder.Script;
import com.klarna.hiverunner.config.HiveRunnerConfig;
import com.klarna.reflection.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRunnerExtension
implements AfterEachCallback,
TestInstancePostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveRunnerExtension.class);
    private final HiveRunnerCore core;
    private final HiveRunnerConfig config = new HiveRunnerConfig();
    private Path basedir;
    private HiveShellContainer container;
    private List<? extends Script> scriptsUnderTest;

    public HiveRunnerExtension() {
        this.core = new HiveRunnerCore();
    }

    public void postProcessTestInstance(Object target, ExtensionContext extensionContext) {
        this.setupConfig(target);
        try {
            this.basedir = Files.createTempDirectory("hiverunner_test", new FileAttribute[0]);
            this.container = this.createHiveServerContainer(this.scriptsUnderTest, target, this.basedir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.scriptsUnderTest = this.container.getScriptsUnderTest();
    }

    private void setupConfig(Object target) {
        Set<Field> fields = ReflectionUtils.getAllFields(target.getClass(), (Predicate<? super Field>)Predicates.and((Predicate)org.reflections.ReflectionUtils.withAnnotation(HiveRunnerSetup.class), (Predicate)org.reflections.ReflectionUtils.withType(HiveRunnerConfig.class)));
        Preconditions.checkState((fields.size() <= 1 ? 1 : 0) != 0, (Object)"Only one field of type HiveRunnerConfig should be annotated with @HiveRunnerSetup");
        if (!fields.isEmpty()) {
            this.config.override(ReflectionUtils.getFieldValue(target, fields.iterator().next().getName(), HiveRunnerConfig.class));
        }
    }

    private void tearDown(Object target) {
        if (this.container != null) {
            LOGGER.info("Tearing down {}", target.getClass());
            this.container.tearDown();
        }
        this.deleteTempFolder(this.basedir);
    }

    private void deleteTempFolder(Path directory) {
        try {
            FileUtils.deleteDirectory((File)directory.toFile());
        }
        catch (IOException e) {
            LOGGER.debug("Temporary folder was not deleted successfully: " + directory);
        }
    }

    private HiveShellContainer createHiveServerContainer(List<? extends Script> scripts, Object testCase, Path basedir) throws IOException {
        return this.core.createHiveServerContainer(scripts, testCase, basedir, this.config);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.tearDown(extensionContext.getRequiredTestInstance());
    }
}

