/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.klarna.hiverunner.HiveRunnerCore;
import com.klarna.hiverunner.HiveRunnerRule;
import com.klarna.hiverunner.HiveShellContainer;
import com.klarna.hiverunner.ThrowOnTimeout;
import com.klarna.hiverunner.TimeoutException;
import com.klarna.hiverunner.annotations.HiveRunnerSetup;
import com.klarna.hiverunner.builder.Script;
import com.klarna.hiverunner.config.HiveRunnerConfig;
import com.klarna.reflection.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class StandaloneHiveRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneHiveRunner.class);
    private HiveShellContainer container;
    private final HiveRunnerConfig config = new HiveRunnerConfig();

    public StandaloneHiveRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected HiveRunnerConfig getHiveRunnerConfig() {
        return this.config;
    }

    protected List<TestRule> getTestRules(Object target) {
        Path testBaseDir = null;
        try {
            testBaseDir = Files.createTempDirectory("hiverunner_tests", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HiveRunnerRule hiveRunnerRule = new HiveRunnerRule(this, target, testBaseDir);
        ArrayList<TestRule> rules = new ArrayList<TestRule>();
        rules.addAll(super.getTestRules(target));
        rules.add(hiveRunnerRule);
        rules.add(ThrowOnTimeout.create(this.config, this.getName()));
        rules.add(this.getHiveRunnerConfigRule(target));
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            this.setLogContext(method);
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            try {
                this.runTestMethod(method, eachNotifier, this.config.getTimeoutRetries());
            }
            finally {
                eachNotifier.fireTestFinished();
                this.clearLogContext();
            }
        }
    }

    protected final void runTestMethod(FrameworkMethod method, EachTestNotifier notifier, int retriesLeft) {
        Statement statement = this.methodBlock(method);
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            notifier.addFailedAssumption(e);
        }
        catch (TimeoutException e) {
            if (--retriesLeft >= 0) {
                LOGGER.warn("Test case timed out. Will attempt retry {} more times. Turn on log level DEBUG for stacktrace", (Object)retriesLeft);
                LOGGER.debug(e.getMessage(), (Throwable)e);
                this.tearDown();
                this.runTestMethod(method, notifier, retriesLeft);
            } else {
                notifier.addFailure((Throwable)e);
            }
        }
        catch (Throwable e) {
            notifier.addFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveShellContainer evaluateStatement(List<? extends Script> scripts, Object target, Path temporaryFolder, Statement base) throws Throwable {
        this.container = null;
        FileUtil.setPermission((File)temporaryFolder.toFile(), (FsPermission)FsPermission.getDirDefault());
        try {
            LOGGER.info("Setting up {} in {}", (Object)this.getName(), (Object)temporaryFolder.getRoot());
            this.container = this.createHiveServerContainer(scripts, target, temporaryFolder);
            base.evaluate();
            HiveShellContainer hiveShellContainer = this.container;
            return hiveShellContainer;
        }
        finally {
            this.tearDown();
        }
    }

    private void tearDown() {
        this.tearDownContainer();
        if (this.container != null) {
            this.deleteTempFolder(this.container.getBaseDir());
        }
    }

    private void tearDownContainer() {
        if (this.container != null) {
            LOGGER.info("Tearing down {}", (Object)this.getName());
            try {
                this.container.tearDown();
            }
            catch (Throwable e) {
                LOGGER.warn("Tear down failed: " + e.getMessage(), e);
            }
        }
    }

    private void deleteTempFolder(Path directory) {
        try {
            FileUtils.deleteDirectory((File)directory.toFile());
        }
        catch (IOException e) {
            LOGGER.debug("Temporary folder was not deleted successfully: " + directory);
        }
    }

    private HiveShellContainer createHiveServerContainer(List<? extends Script> scripts, Object testCase, Path baseDir) throws IOException {
        HiveRunnerCore core = new HiveRunnerCore();
        return core.createHiveServerContainer(scripts, testCase, baseDir, this.config);
    }

    private TestRule getHiveRunnerConfigRule(final Object target) {
        return new TestRule(){

            public Statement apply(Statement base, Description description) {
                Set<Field> fields = ReflectionUtils.getAllFields(target.getClass(), (Predicate<? super Field>)Predicates.and((Predicate)org.reflections.ReflectionUtils.withAnnotation(HiveRunnerSetup.class), (Predicate)org.reflections.ReflectionUtils.withType(HiveRunnerConfig.class)));
                Preconditions.checkState((fields.size() <= 1 ? 1 : 0) != 0, (Object)"Exact one field of type HiveRunnerConfig should to be annotated with @HiveRunnerSetup");
                if (!fields.isEmpty()) {
                    StandaloneHiveRunner.this.config.override(ReflectionUtils.getFieldValue(target, fields.iterator().next().getName(), HiveRunnerConfig.class));
                }
                return base;
            }
        };
    }

    private void clearLogContext() {
        MDC.clear();
    }

    private void setLogContext(FrameworkMethod method) {
        MDC.put((String)"testClassShort", (String)this.getTestClass().getJavaClass().getSimpleName());
        MDC.put((String)"testClass", (String)this.getTestClass().getJavaClass().getName());
        MDC.put((String)"testMethod", (String)method.getName());
    }
}

