/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.io.Resources;
import com.klarna.hiverunner.HiveServerContainer;
import com.klarna.hiverunner.HiveServerContext;
import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.HiveShellContainer;
import com.klarna.hiverunner.StandaloneHiveServerContext;
import com.klarna.hiverunner.annotations.HiveProperties;
import com.klarna.hiverunner.annotations.HiveResource;
import com.klarna.hiverunner.annotations.HiveSQL;
import com.klarna.hiverunner.annotations.HiveSetupScript;
import com.klarna.hiverunner.builder.HiveShellBuilder;
import com.klarna.hiverunner.builder.Script;
import com.klarna.hiverunner.config.HiveRunnerConfig;
import com.klarna.reflection.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class HiveRunnerCore {
    HiveRunnerCore() {
    }

    HiveShellContainer createHiveServerContainer(List<? extends Script> scripts, Object testCase, Path baseDir, HiveRunnerConfig config) throws IOException {
        StandaloneHiveServerContext context = new StandaloneHiveServerContext(baseDir, config);
        return this.buildShell(scripts, testCase, config, context);
    }

    private HiveShellContainer buildShell(List<? extends Script> scripts, Object testCase, HiveRunnerConfig config, HiveServerContext context) throws IOException {
        HiveServerContainer hiveTestHarness = new HiveServerContainer(context);
        HiveShellBuilder hiveShellBuilder = new HiveShellBuilder();
        hiveShellBuilder.setCommandShellEmulation(config.getCommandShellEmulator());
        HiveShellField shellSetter = this.loadScriptUnderTest(testCase, hiveShellBuilder);
        if (scripts != null) {
            hiveShellBuilder.overrideScriptsUnderTest(scripts);
        }
        hiveShellBuilder.setHiveServerContainer(hiveTestHarness);
        this.loadAnnotatedResources(testCase, hiveShellBuilder);
        this.loadAnnotatedProperties(testCase, hiveShellBuilder);
        this.loadAnnotatedSetupScripts(testCase, hiveShellBuilder);
        HiveShellContainer shell = hiveShellBuilder.buildShell();
        shellSetter.setShell(shell);
        if (shellSetter.isAutoStart()) {
            shell.start();
        }
        return shell;
    }

    private HiveShellField loadScriptUnderTest(final Object testCaseInstance, HiveShellBuilder hiveShellBuilder) {
        try {
            Set<Field> fields = ReflectionUtils.getAllFields(testCaseInstance.getClass(), (Predicate<? super Field>)org.reflections.ReflectionUtils.withAnnotation(HiveSQL.class));
            Preconditions.checkState((fields.size() == 1 ? 1 : 0) != 0, (Object)"Exact one field should to be annotated with @HiveSQL");
            final Field field = fields.iterator().next();
            ArrayList<Path> scriptPaths = new ArrayList<Path>();
            HiveSQL annotation = field.getAnnotation(HiveSQL.class);
            for (String scriptFilePath : annotation.files()) {
                Path file = Paths.get(Resources.getResource((String)scriptFilePath).toURI());
                this.assertFileExists(file);
                scriptPaths.add(file);
            }
            Charset charset = annotation.encoding().equals("") ? Charset.defaultCharset() : Charset.forName(annotation.encoding());
            final boolean isAutoStart = annotation.autoStart();
            hiveShellBuilder.setScriptsUnderTest(scriptPaths, charset);
            return new HiveShellField(){

                @Override
                public void setShell(HiveShell shell) {
                    ReflectionUtils.setField(testCaseInstance, field.getName(), shell);
                }

                @Override
                public boolean isAutoStart() {
                    return isAutoStart;
                }
            };
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to init field annotated with @HiveSQL: " + t.getMessage(), t);
        }
    }

    private void assertFileExists(Path file) {
        Preconditions.checkState((boolean)Files.exists(file, new LinkOption[0]), (Object)("File " + file + " does not exist"));
    }

    private void loadAnnotatedSetupScripts(Object testCase, HiveShellBuilder workFlowBuilder) {
        Set<Field> setupScriptFields = ReflectionUtils.getAllFields(testCase.getClass(), (Predicate<? super Field>)org.reflections.ReflectionUtils.withAnnotation(HiveSetupScript.class));
        for (Field setupScriptField : setupScriptFields) {
            if (ReflectionUtils.isOfType(setupScriptField, String.class)) {
                String script = ReflectionUtils.getFieldValue(testCase, setupScriptField.getName(), String.class);
                workFlowBuilder.addSetupScript(script);
                continue;
            }
            if (ReflectionUtils.isOfType(setupScriptField, File.class) || ReflectionUtils.isOfType(setupScriptField, Path.class)) {
                Path path = this.getMandatoryPathFromField(testCase, setupScriptField);
                workFlowBuilder.addSetupScript(HiveRunnerCore.readAll(path));
                continue;
            }
            throw new IllegalArgumentException("Field annotated with @HiveSetupScript currently only supports type String, File and Path");
        }
    }

    private static String readAll(Path path) {
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + path + ": " + e.getMessage(), e);
        }
    }

    private void loadAnnotatedResources(Object testCase, HiveShellBuilder workFlowBuilder) throws IOException {
        Set<Field> fields = ReflectionUtils.getAllFields(testCase.getClass(), (Predicate<? super Field>)org.reflections.ReflectionUtils.withAnnotation(HiveResource.class));
        for (Field resourceField : fields) {
            HiveResource annotation = resourceField.getAnnotation(HiveResource.class);
            String targetFile = annotation.targetFile();
            if (ReflectionUtils.isOfType(resourceField, String.class)) {
                String data = ReflectionUtils.getFieldValue(testCase, resourceField.getName(), String.class);
                workFlowBuilder.addResource(targetFile, data);
                continue;
            }
            if (ReflectionUtils.isOfType(resourceField, File.class) || ReflectionUtils.isOfType(resourceField, Path.class)) {
                Path dataFile = this.getMandatoryPathFromField(testCase, resourceField);
                workFlowBuilder.addResource(targetFile, dataFile);
                continue;
            }
            throw new IllegalArgumentException("Fields annotated with @HiveResource currently only supports field type String, File or Path");
        }
    }

    private Path getMandatoryPathFromField(Object testCase, Field resourceField) {
        Path path;
        if (ReflectionUtils.isOfType(resourceField, File.class)) {
            File dataFile = ReflectionUtils.getFieldValue(testCase, resourceField.getName(), File.class);
            path = Paths.get(dataFile.toURI());
        } else if (ReflectionUtils.isOfType(resourceField, Path.class)) {
            path = ReflectionUtils.getFieldValue(testCase, resourceField.getName(), Path.class);
        } else {
            throw new IllegalArgumentException("Only Path or File type is allowed on annotated field " + resourceField);
        }
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File %s does not exist", (Object[])new Object[]{path});
        return path;
    }

    private void loadAnnotatedProperties(Object testCase, HiveShellBuilder workFlowBuilder) {
        for (Field hivePropertyField : ReflectionUtils.getAllFields(testCase.getClass(), (Predicate<? super Field>)org.reflections.ReflectionUtils.withAnnotation(HiveProperties.class))) {
            Preconditions.checkState((boolean)ReflectionUtils.isOfType(hivePropertyField, Map.class), (Object)"Field annotated with @HiveProperties should be of type Map<String, String>");
            workFlowBuilder.putAllProperties(ReflectionUtils.getFieldValue(testCase, hivePropertyField.getName(), Map.class));
        }
    }

    static interface HiveShellField {
        public void setShell(HiveShell var1);

        public boolean isAutoStart();
    }
}

