/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner;

import com.klarna.hiverunner.HiveShellContainer;
import com.klarna.hiverunner.StandaloneHiveRunner;
import com.klarna.hiverunner.builder.Script;
import java.nio.file.Path;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRunnerRule
implements TestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveRunnerRule.class);
    private final StandaloneHiveRunner runner;
    private final Object target;
    private final Path testBaseDir;
    private List<? extends Script> scriptsUnderTest;

    HiveRunnerRule(StandaloneHiveRunner runner, Object target, Path testBaseDir) {
        this.runner = runner;
        this.target = target;
        this.testBaseDir = testBaseDir;
    }

    public List<? extends Script> getScriptsUnderTest() {
        return this.scriptsUnderTest;
    }

    public void setScriptsUnderTest(List<? extends Script> scriptsUnderTest) {
        LOGGER.debug("Setting up hive runner scripts under test");
        this.scriptsUnderTest = scriptsUnderTest;
    }

    public Statement apply(Statement base, Description description) {
        LOGGER.debug("Running hive runner rule apply");
        return new HiveRunnerRuleStatement(this.runner, this.target, base, this.testBaseDir);
    }

    class HiveRunnerRuleStatement
    extends Statement {
        private Object target;
        private Statement base;
        private Path testBaseDir;
        private StandaloneHiveRunner runner;

        private HiveRunnerRuleStatement(StandaloneHiveRunner runner, Object target, Statement base, Path testBaseDir) {
            this.runner = runner;
            this.target = target;
            this.base = base;
            this.testBaseDir = testBaseDir;
        }

        public void evaluate() throws Throwable {
            LOGGER.debug("Hive runner rule evaluate method");
            HiveShellContainer container = this.runner.evaluateStatement(HiveRunnerRule.this.scriptsUnderTest, this.target, this.testBaseDir, this.base);
            HiveRunnerRule.this.scriptsUnderTest = container.getScriptsUnderTest();
        }
    }
}

