/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.klarna.hiverunner.data.Converters;
import com.klarna.hiverunner.data.FileParser;
import com.klarna.hiverunner.data.TsvFileParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;

class TableDataBuilder {
    private final ImmutableMultimap.Builder<Map<String, String>, HCatRecord> rowsBuilder = ImmutableMultimap.builder();
    private final HCatSchema schema;
    private final List<HCatFieldSchema> partitionColumns;
    private HCatRecord row;
    private List<String> names;

    TableDataBuilder(HCatTable table) {
        this.schema = new HCatSchema((List)ImmutableList.builder().addAll((Iterable)table.getCols()).addAll((Iterable)table.getPartCols()).build());
        this.partitionColumns = table.getPartCols();
        this.withAllColumns();
    }

    TableDataBuilder withColumns(String ... names) {
        Preconditions.checkArgument((((String[])Preconditions.checkNotNull((Object)names)).length > 0 ? 1 : 0) != 0, (Object)"Column names must be provided.");
        this.names = new ArrayList<String>(names.length);
        for (String name : names) {
            this.checkColumn(name);
            this.names.add(name);
        }
        return this;
    }

    TableDataBuilder withAllColumns() {
        this.names = this.schema.getFieldNames();
        return this;
    }

    TableDataBuilder newRow() {
        this.flushRow();
        this.row = new DefaultHCatRecord(this.schema.size());
        return this;
    }

    TableDataBuilder addRow(Object ... values) {
        return this.newRow().setRow(values);
    }

    TableDataBuilder setRow(Object ... values) {
        Preconditions.checkArgument((values.length == this.names.size() ? 1 : 0) != 0, (String)"Expected %d values, got %d", (Object[])new Object[]{this.names.size(), values.length});
        for (int i = 0; i < values.length; ++i) {
            this.set(this.names.get(i), values[i]);
        }
        return this;
    }

    TableDataBuilder addRowsFromTsv(File file) {
        return this.addRowsFrom(file, new TsvFileParser());
    }

    TableDataBuilder addRowsFromDelimited(File file, String delimiter, Object nullValue) {
        return this.addRowsFrom(file, new TsvFileParser().withDelimiter(delimiter).withNullValue(nullValue));
    }

    TableDataBuilder addRowsFrom(File file, FileParser fileParser) {
        if (fileParser.hasColumnNames()) {
            Preconditions.checkArgument((boolean)this.names.equals(this.schema.getFieldNames()), (Object)"Manual column spec and header column spec are mutually exclusive");
            String[] columns = (String[])FluentIterable.from(fileParser.getColumnNames(file)).transform(this.toLowerCase()).toArray(String.class);
            this.withColumns(columns);
        }
        return this.addRows(fileParser.parse(file, this.schema, this.names));
    }

    private Function<String, String> toLowerCase() {
        return new Function<String, String>(){

            public String apply(String t) {
                return t.toLowerCase();
            }
        };
    }

    private TableDataBuilder addRows(List<Object[]> rows) {
        for (Object[] row : rows) {
            this.addRow(row);
        }
        return this;
    }

    TableDataBuilder copyRow() {
        Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No previous row to copy.");
        DefaultHCatRecord copy = new DefaultHCatRecord(new ArrayList(this.row.getAll()));
        this.flushRow();
        this.row = copy;
        return this;
    }

    TableDataBuilder set(String name, Object value) {
        Object converted;
        PrimitiveTypeInfo typeInfo;
        this.checkColumn(name);
        try {
            typeInfo = this.schema.get(name).getTypeInfo();
        }
        catch (HCatException e) {
            throw new IllegalArgumentException("Error getting type info for " + name, e);
        }
        try {
            converted = Converters.convert(value, typeInfo);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Invalid value for " + name + ". Got '" + value + "' (" + value.getClass().getSimpleName() + "). Expected " + typeInfo.getTypeName() + ".", e);
        }
        try {
            this.row.set(name, this.schema, converted);
        }
        catch (HCatException e) {
            throw new RuntimeException("Error setting value for " + name, e);
        }
        return this;
    }

    private Object get(String name) {
        this.checkColumn(name);
        try {
            return this.row.get(name, this.schema);
        }
        catch (HCatException e) {
            throw new RuntimeException("Error getting value for " + name, e);
        }
    }

    private void flushRow() {
        if (this.row != null) {
            this.rowsBuilder.put(this.createPartitionSpec(), (Object)this.row);
        }
    }

    private Map<String, String> createPartitionSpec() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (HCatFieldSchema partitionColumn : this.partitionColumns) {
            String name = partitionColumn.getName();
            Object value = this.get(name);
            Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"Value for partition column %s must not be null.", (Object[])new Object[]{name});
            builder.put((Object)name, (Object)value.toString());
        }
        return builder.build();
    }

    Multimap<Map<String, String>, HCatRecord> build() {
        this.flushRow();
        return this.rowsBuilder.build();
    }

    private void checkColumn(String name) {
        Preconditions.checkArgument((boolean)this.schema.getFieldNames().contains(name.toLowerCase()), (String)"Column %s does not exist", (Object[])new Object[]{name});
    }
}

