/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.reflection;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.annotation.Nullable;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static void setStaticField(Class clazz, String fieldName, Object value) {
        ReflectionUtils.setField(clazz, null, fieldName, value);
    }

    public static void setField(Object instance, String fieldName, Object value) {
        ReflectionUtils.setField(instance.getClass(), instance, fieldName, value);
    }

    private static void setField(Class clazz, Object instance, String fieldName, Object value) {
        try {
            Optional<Field> optional = ReflectionUtils.getField(clazz, fieldName);
            Preconditions.checkArgument((boolean)optional.isPresent(), (Object)("Failed to set field '" + fieldName + "' on '" + instance));
            Field field = (Field)optional.get();
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(accessible);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to set field '" + fieldName + "' on '" + instance + "': " + e.getMessage(), e);
        }
    }

    public static Optional<Field> getField(Class<?> type, String fieldName) {
        Optional<Field> field = Iterables.tryFind((Iterable)Lists.newArrayList((Object[])type.getDeclaredFields()), ReflectionUtils.havingFieldName(fieldName));
        if (!field.isPresent() && type.getSuperclass() != null) {
            field = ReflectionUtils.getField(type.getSuperclass(), fieldName);
        }
        return field;
    }

    public static Set<Field> getAllFields(Class aClass, Predicate<? super Field> predicate) {
        return org.reflections.ReflectionUtils.getAllFields((Class)aClass, predicate);
    }

    public static <T> T getFieldValue(Object testCase, String name, Class<T> type) {
        return ReflectionUtils.getFieldValue(testCase, testCase.getClass(), name, type, false);
    }

    public static <T> T getStaticFieldValue(Class testCaseClass, String name, Class<T> type) {
        return ReflectionUtils.getFieldValue(null, testCaseClass, name, type, true);
    }

    private static <T> T getFieldValue(Object testCase, Class testCaseClass, String name, Class<T> type, boolean isStatic) {
        try {
            Field field = testCaseClass.getDeclaredField(name);
            boolean accessible = field.isAccessible();
            Preconditions.checkState((boolean)field.getType().isAssignableFrom(type), (String)"Field %s must be assignable from ", (Object[])new Object[]{type});
            Preconditions.checkState((!isStatic || Modifier.isStatic(field.getModifiers()) ? 1 : 0) != 0, (String)"Field %s must be static ", (Object[])new Object[]{field});
            field.setAccessible(true);
            Object value = field.get(testCase);
            field.setAccessible(accessible);
            return (T)value;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Failed to lookup field '" + name + "' for '" + testCaseClass + "': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to get value of field '" + name + "' for '" + testCaseClass + "': " + e.getMessage(), e);
        }
    }

    public static boolean isOfType(Field setupScriptField, Class type) {
        return setupScriptField.getType().isAssignableFrom(type);
    }

    private static Predicate<Field> havingFieldName(final String fieldName) {
        return new Predicate<Field>(){

            public boolean apply(@Nullable Field field) {
                return fieldName.equals(field.getName());
            }
        };
    }
}

