/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import javacard.framework.Util;

public enum ApduCase {
    Case1(false),
    Case2(false),
    Case2Extended(true),
    Case3(false),
    Case3Extended(true),
    Case4(false),
    Case4Extended(true);

    private final boolean extended;

    private ApduCase(boolean extended) {
        this.extended = extended;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public static ApduCase getCase(byte[] command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (command.length < 4) {
            throw new IllegalArgumentException("command: malformed APDU, length < 4");
        }
        if (command.length == 4) {
            return Case1;
        }
        if (command.length == 5) {
            return Case2;
        }
        if (command.length == 7 && command[4] == 0) {
            return Case2Extended;
        }
        if (command[4] == 0) {
            int offset;
            short lc = Util.getShort(command, (short)5);
            if (lc + (offset = 7) == command.length) {
                return Case3Extended;
            }
            if (lc + offset + 2 == command.length) {
                return Case4Extended;
            }
            throw new IllegalArgumentException("Invalid extended C-APDU: Lc or Le is invalid");
        }
        int lc = command[4] & 0xFF;
        int offset = 5;
        if (lc + offset == command.length) {
            return Case3;
        }
        if (lc + offset + 1 == command.length) {
            return Case4;
        }
        throw new IllegalArgumentException("Invalid C-APDU: Lc or Le is invalid");
    }
}

