/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.asn1.x9;

import com.licel.jcardsim.bouncycastle.asn1.ASN1Encodable;
import com.licel.jcardsim.bouncycastle.asn1.ASN1EncodableVector;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Sequence;
import com.licel.jcardsim.bouncycastle.asn1.DERInteger;
import com.licel.jcardsim.bouncycastle.asn1.DERObject;
import com.licel.jcardsim.bouncycastle.asn1.DERObjectIdentifier;
import com.licel.jcardsim.bouncycastle.asn1.DERSequence;
import com.licel.jcardsim.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import java.math.BigInteger;

public class X9FieldID
extends ASN1Encodable
implements X9ObjectIdentifiers {
    private DERObjectIdentifier id;
    private DERObject parameters;

    public X9FieldID(BigInteger bigInteger) {
        this.id = prime_field;
        this.parameters = new DERInteger(bigInteger);
    }

    public X9FieldID(int n, int n2, int n3, int n4) {
        this.id = characteristic_two_field;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(n));
        if (n3 == 0) {
            aSN1EncodableVector.add(tpBasis);
            aSN1EncodableVector.add(new DERInteger(n2));
        } else {
            aSN1EncodableVector.add(ppBasis);
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add(new DERInteger(n2));
            aSN1EncodableVector2.add(new DERInteger(n3));
            aSN1EncodableVector2.add(new DERInteger(n4));
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        }
        this.parameters = new DERSequence(aSN1EncodableVector);
    }

    public X9FieldID(ASN1Sequence aSN1Sequence) {
        this.id = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.parameters = (DERObject)aSN1Sequence.getObjectAt(1);
    }

    public DERObjectIdentifier getIdentifier() {
        return this.id;
    }

    public DERObject getParameters() {
        return this.parameters;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.id);
        aSN1EncodableVector.add(this.parameters);
        return new DERSequence(aSN1EncodableVector);
    }
}

