/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.crypto.generators;

import com.licel.jcardsim.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.licel.jcardsim.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.licel.jcardsim.bouncycastle.crypto.KeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.licel.jcardsim.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

