/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.crypto.generators;

import com.licel.jcardsim.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.licel.jcardsim.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.licel.jcardsim.bouncycastle.crypto.KeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECDomainParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.licel.jcardsim.bouncycastle.math.ec.ECConstants;
import com.licel.jcardsim.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        while ((bigInteger = new BigInteger(n, this.random)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        ECPoint eCPoint = this.params.getG().multiply(bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }
}

