/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import java.math.BigInteger;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;

public final class ByteContainer {
    private byte[] data;
    private byte memoryType;
    private short length = 0;

    public ByteContainer() {
        this(0);
    }

    public ByteContainer(byte memoryType) {
        this.memoryType = memoryType;
    }

    public ByteContainer(BigInteger bInteger) {
        this.setBigInteger(bInteger);
    }

    public ByteContainer(byte[] buff, short offset, short length) {
        this.setBytes(buff, offset, length);
    }

    public void setBigInteger(BigInteger bInteger) {
        if (bInteger.signum() < 0) {
            throw new IllegalArgumentException("Negative bInteger");
        }
        byte[] array = bInteger.toByteArray();
        if (array[0] == 0 && array.length > 1) {
            byte[] trimmedArray = new byte[array.length - 1];
            System.arraycopy(array, 1, trimmedArray, 0, trimmedArray.length);
            this.setBytes(trimmedArray);
        } else {
            this.setBytes(array);
        }
    }

    public void setBytes(byte[] buff) {
        this.setBytes(buff, (short)0, (short)buff.length);
    }

    public void setBytes(byte[] buff, short offset, short length) {
        if (this.data == null || (short)this.data.length < length) {
            switch (this.memoryType) {
                case 2: {
                    this.data = JCSystem.makeTransientByteArray(length, (byte)2);
                    break;
                }
                case 1: {
                    this.data = JCSystem.makeTransientByteArray(length, (byte)2);
                    break;
                }
                default: {
                    this.data = new byte[length];
                }
            }
        }
        Util.arrayCopy(buff, offset, this.data, (short)0, length);
        this.length = length;
    }

    public BigInteger getBigInteger() {
        if (this.length == 0) {
            CryptoException.throwIt((short)2);
        }
        return new BigInteger(1, this.data);
    }

    public byte[] getBytes(byte event) {
        if (this.length == 0) {
            CryptoException.throwIt((short)2);
        }
        byte[] result = JCSystem.makeTransientByteArray(this.length, event);
        this.getBytes(result, (short)0);
        return result;
    }

    public short getBytes(byte[] dest, short offset) {
        if (this.length == 0) {
            CryptoException.throwIt((short)2);
        }
        if (dest.length - offset < this.length) {
            CryptoException.throwIt((short)1);
        }
        Util.arrayCopy(this.data, (short)0, dest, offset, this.length);
        return this.length;
    }

    public void clear() {
        if (this.data != null) {
            Util.arrayFillNonAtomic(this.data, (short)0, (short)this.data.length, (byte)0);
        }
        this.length = 0;
    }

    public boolean isInitialized() {
        return this.length > 0;
    }
}

