/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.BasicAgreement;
import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.licel.jcardsim.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.licel.jcardsim.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA1Digest;
import com.licel.jcardsim.bouncycastle.crypto.params.DHKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.licel.jcardsim.bouncycastle.math.ec.ECPoint;
import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.DHPrivateKeyImpl;
import com.licel.jcardsim.crypto.ECPrivateKeyImpl;
import java.math.BigInteger;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.KeyAgreement;
import javacard.security.PrivateKey;

public class KeyAgreementImpl
extends KeyAgreement {
    BasicAgreement engine;
    SHA1Digest digestEngine;
    byte algorithm;
    PrivateKey privateKey;

    public KeyAgreementImpl(byte algorithm) {
        this.algorithm = algorithm;
        switch (algorithm) {
            case 1: 
            case 3: {
                this.engine = new ECDHBasicAgreement();
                break;
            }
            case 2: 
            case 4: {
                this.engine = new ECDHCBasicAgreement();
                break;
            }
            case 6: {
                this.engine = new ECDHFullAgreement();
                break;
            }
            case 7: {
                this.engine = new DHBasicAgreement();
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        this.digestEngine = new SHA1Digest();
    }

    @Override
    public void init(PrivateKey privateKey) throws CryptoException {
        if (privateKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!(privateKey instanceof ECPrivateKeyImpl) && !(privateKey instanceof DHPrivateKeyImpl)) {
            CryptoException.throwIt((short)1);
        }
        if (privateKey instanceof ECPrivateKeyImpl) {
            this.engine.init(((ECPrivateKeyImpl)privateKey).getParameters());
            this.privateKey = privateKey;
        } else {
            this.engine.init(((DHPrivateKeyImpl)privateKey).getParameters());
            this.privateKey = privateKey;
        }
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public short generateSecret(byte[] publicData, short publicOffset, short publicLength, byte[] secret, short secretOffset) throws CryptoException {
        byte[] result;
        if (this.algorithm == 7) {
            BigInteger pubKey = new ByteContainer(publicData, publicOffset, publicLength).getBigInteger();
            DHParameters baseParam = ((DHKeyParameters)((DHPrivateKeyImpl)this.privateKey).getParameters()).getParameters();
            BigInteger retAgreement = this.engine.calculateAgreement(new DHPublicKeyParameters(pubKey, baseParam));
            return new ByteContainer(retAgreement).getBytes(secret, secretOffset);
        }
        byte[] publicKey = new byte[publicLength];
        Util.arrayCopyNonAtomic(publicData, publicOffset, publicKey, (short)0, publicLength);
        ECPublicKeyParameters ecp = new ECPublicKeyParameters(((ECPrivateKeyParameters)((ECPrivateKeyImpl)this.privateKey).getParameters()).getParameters().getCurve().decodePoint(publicKey), ((ECPrivateKeyParameters)((ECPrivateKeyImpl)this.privateKey).getParameters()).getParameters());
        byte[] num = this.engine.calculateAgreement(ecp).toByteArray();
        if (this.algorithm != 6) {
            int fieldSize = ((ECPrivateKeyImpl)this.privateKey).getDomainParameters().getCurve().getFieldSize();
            result = new byte[(fieldSize + 7) / 8];
            int numBytes = Math.min(num.length, result.length);
            Util.arrayCopyNonAtomic(num, (short)(num.length - numBytes), result, (short)(result.length - numBytes), (short)numBytes);
            Util.arrayFillNonAtomic(result, (short)0, (short)(result.length - numBytes), (byte)0);
        } else {
            result = num;
        }
        switch (this.algorithm) {
            case 1: 
            case 2: {
                byte[] hashResult = new byte[20];
                this.digestEngine.update(result, 0, result.length);
                this.digestEngine.doFinal(hashResult, 0);
                Util.arrayCopyNonAtomic(hashResult, (short)0, secret, secretOffset, (short)hashResult.length);
                return (short)hashResult.length;
            }
            case 3: 
            case 4: 
            case 6: {
                Util.arrayCopyNonAtomic(result, (short)0, secret, secretOffset, (short)result.length);
                return (short)result.length;
            }
        }
        CryptoException.throwIt((short)3);
        return -1;
    }

    static class ECDHFullAgreement
    implements BasicAgreement {
        private ECPrivateKeyParameters key;

        @Override
        public void init(CipherParameters privateKey) {
            this.key = (ECPrivateKeyParameters)privateKey;
        }

        @Override
        public BigInteger calculateAgreement(CipherParameters publicKey) {
            ECPublicKeyParameters pub = (ECPublicKeyParameters)publicKey;
            ECPoint result = pub.getQ().multiply(this.key.getD());
            return new BigInteger(1, result.getEncoded());
        }
    }
}

