/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.MD5Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA1Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA256Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA384Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA512Digest;
import com.licel.jcardsim.bouncycastle.crypto.util.Pack;
import java.lang.reflect.Field;
import javacard.security.CryptoException;
import javacard.security.InitializedMessageDigest;

public class MessageDigestImpl
extends InitializedMessageDigest {
    private Digest engine;
    private byte algorithm;
    private short blockSize;
    private String byteCountFieldName = "byteCount";
    private Class digestClass;
    private byte componentSize;
    private byte componentCount;
    private byte componentStartIdx;

    public MessageDigestImpl(byte algorithm) {
        this.algorithm = algorithm;
        this.blockSize = (short)64;
        this.componentStartIdx = 1;
        switch (algorithm) {
            case 1: {
                this.engine = new SHA1Digest();
                this.digestClass = this.engine.getClass();
                break;
            }
            case 2: {
                this.engine = new MD5Digest();
                this.digestClass = this.engine.getClass();
                break;
            }
            case 3: {
                this.engine = new RIPEMD160Digest();
                this.digestClass = this.engine.getClass();
                this.componentStartIdx = 0;
                break;
            }
            case 4: {
                this.engine = new SHA256Digest();
                this.digestClass = this.engine.getClass();
                break;
            }
            case 5: {
                this.engine = new SHA384Digest();
                this.blockSize = (short)128;
                this.byteCountFieldName = "byteCount1";
                this.digestClass = this.engine.getClass().getSuperclass();
                break;
            }
            case 6: {
                this.engine = new SHA512Digest();
                this.blockSize = (short)128;
                this.byteCountFieldName = "byteCount1";
                this.digestClass = this.engine.getClass().getSuperclass();
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        this.componentSize = (byte)(this.blockSize == 64 ? 4 : 8);
        this.componentCount = (byte)(this.engine.getDigestSize() / this.componentSize);
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte getLength() {
        return (byte)this.engine.getDigestSize();
    }

    @Override
    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) {
        this.engine.update(inBuff, inOffset, inLength);
        return (short)this.engine.doFinal(outBuff, outOffset);
    }

    @Override
    public void update(byte[] inBuff, short inOffset, short inLength) {
        this.engine.update(inBuff, inOffset, inLength);
    }

    @Override
    public void reset() {
        this.engine.reset();
    }

    @Override
    public void setInitialDigest(byte[] initialDigestBuf, short initialDigestOffset, short initialDigestLength, byte[] digestedMsgLenBuf, short digestedMsgLenOffset, short digestedMsgLenLength) throws CryptoException {
        short i;
        if (this.engine.getDigestSize() != initialDigestLength) {
            CryptoException.throwIt((short)1);
        }
        if (digestedMsgLenLength == 0 || digestedMsgLenLength > 8) {
            CryptoException.throwIt((short)1);
        }
        long byteCount = 0L;
        for (i = 0; i < digestedMsgLenLength; i = (short)(i + 1)) {
            byteCount = (byteCount << 8) + (long)(digestedMsgLenBuf[digestedMsgLenOffset + i] & 0xFF);
        }
        if (byteCount % (long)this.blockSize != 0L) {
            CryptoException.throwIt((short)1);
        }
        try {
            for (i = 0; i < this.componentCount; i = (short)((byte)(i + 1))) {
                Field h = this.digestClass.getDeclaredField("H" + (i + this.componentStartIdx));
                h.setAccessible(true);
                if (this.componentSize == 4) {
                    h.setInt(this.engine, Pack.bigEndianToInt(initialDigestBuf, initialDigestOffset + i * this.componentSize));
                    continue;
                }
                h.setLong(this.engine, Pack.bigEndianToLong(initialDigestBuf, initialDigestOffset + i * this.componentSize));
            }
            Field h = this.digestClass.getSuperclass().getDeclaredField(this.byteCountFieldName);
            h.setAccessible(true);
            h.setLong(this.engine, byteCount);
        }
        catch (Exception e) {
            CryptoException.throwIt((short)5);
        }
    }

    void getIntermediateDigest(byte[] intermediateDigest, int off) {
        try {
            for (byte i = 0; i < this.componentCount; i = (byte)(i + 1)) {
                Field h = this.digestClass.getDeclaredField("H" + (i + this.componentStartIdx));
                h.setAccessible(true);
                if (this.componentSize == 4) {
                    Pack.intToBigEndian(h.getInt(this.engine), intermediateDigest, off + i * this.componentSize);
                    continue;
                }
                Pack.longToBigEndian(h.getLong(this.engine), intermediateDigest, off + i * this.componentSize);
            }
        }
        catch (Exception e) {
            CryptoException.throwIt((short)5);
        }
    }

    short getBlockSize() {
        return this.blockSize;
    }
}

