/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.io;

import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.io.CardInterface;
import com.licel.jcardsim.io.JavaxSmartCardInterface;
import com.licel.jcardsim.remote.JavaCardRemoteClient;
import java.util.Properties;

public class CAD {
    public static final byte INTERNAL = 0;
    public static final byte RMI = 1;
    public static final byte JAVAX_SMARTCARDIO = 2;
    byte interfaceType;
    CardInterface cardInterface;

    public CAD(Properties params) {
        byte type = Byte.parseByte(params.getProperty("com.licel.jcardsim.terminal.type", Byte.toString((byte)0)));
        switch (type) {
            case 0: {
                this.cardInterface = new Simulator();
                break;
            }
            case 1: {
                try {
                    String host = params.getProperty("com.licel.jcardsim.terminal.host");
                    int port = Integer.parseInt(params.getProperty("com.licel.jcardsim.terminal.port"));
                    this.cardInterface = new JavaCardRemoteClient(host, port);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("RMI CardInterface init error", e);
                }
            }
            case 2: {
                this.cardInterface = new JavaxSmartCardInterface();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CAD type: " + type);
            }
        }
        this.interfaceType = type;
    }

    public CardInterface getCardInterface() {
        return this.cardInterface;
    }
}

