/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import com.licel.jcardsim.base.CardManager;
import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.remote.BixVReaderIPCProtocol;
import com.licel.jcardsim.remote.BixVReaderProtocol;
import com.licel.jcardsim.remote.BixVReaderTCPProtocol;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Enumeration;
import java.util.Properties;

public class BixVReaderCard {
    Simulator sim;

    public BixVReaderCard(int idx) throws IOException {
        BixVReaderIPCProtocol driverProtocol = new BixVReaderIPCProtocol();
        driverProtocol.connect(idx);
        this.startThread(driverProtocol);
    }

    public BixVReaderCard(String host, int port, int event_port) throws IOException {
        BixVReaderTCPProtocol driverProtocol = new BixVReaderTCPProtocol();
        driverProtocol.connect(host, port, event_port);
        this.startThread(driverProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java com.licel.jcardsim.remote.BixVReaderCard <jcardsim.cfg>");
            System.exit(-1);
        }
        Properties cfg = new Properties();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(args[0]);
            cfg.load(fis);
        }
        Enumeration<?> keys = cfg.propertyNames();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            System.setProperty(propertyName, cfg.getProperty(propertyName));
        }
        String host = System.getProperty("com.licel.jcardsim.bixvreader.host");
        if (host != null) {
            String propKey = "com.licel.jcardsim.bixvreader.port";
            String port = System.getProperty(propKey);
            if (port == null) {
                throw new InvalidParameterException("Missing value for property: " + propKey);
            }
            propKey = "com.licel.jcardsim.bixvreader.eport";
            String eventPort = System.getProperty(propKey);
            if (eventPort == null) {
                throw new InvalidParameterException("Missing value for property: " + propKey);
            }
            BixVReaderCard bixVReaderCard = new BixVReaderCard(host, Integer.parseInt(port), Integer.parseInt(eventPort));
        } else {
            int readerIdx = Integer.parseInt(System.getProperty("com.licel.jcardsim.bixvreader.idx", "0"));
            BixVReaderCard bixVReaderCard = new BixVReaderCard(readerIdx);
        }
    }

    private void startThread(BixVReaderProtocol driverProtocol) throws IOException {
        this.sim = new Simulator();
        IOThread ioThread = new IOThread(this.sim, driverProtocol);
        ShutDownHook hook = new ShutDownHook(ioThread);
        Runtime.getRuntime().addShutdownHook(hook);
        ioThread.start();
        driverProtocol.writeEventCommand(1);
    }

    static class IOThread
    extends Thread {
        BixVReaderProtocol driverProtocol;
        Simulator sim;
        boolean isRunning;

        public IOThread(Simulator sim, BixVReaderProtocol driverProtocol) {
            this.sim = sim;
            this.driverProtocol = driverProtocol;
            this.isRunning = true;
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    int cmd = this.driverProtocol.readCommand();
                    switch (cmd) {
                        case 0: 
                        case 1: {
                            this.sim.reset();
                            this.driverProtocol.writeData(this.sim.getATR());
                            break;
                        }
                        case 2: {
                            byte[] apdu = this.driverProtocol.readData();
                            this.driverProtocol.writeData(CardManager.dispatchApdu(this.sim, apdu));
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    static class ShutDownHook
    extends Thread {
        IOThread ioThread;

        public ShutDownHook(IOThread ioThread) {
            this.ioThread = ioThread;
        }

        @Override
        public void run() {
            this.ioThread.isRunning = false;
            System.out.println("Shutdown connections");
            try {
                this.ioThread.driverProtocol.writeEventCommand(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ioThread.driverProtocol.disconnect();
        }
    }
}

