/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import com.licel.jcardsim.remote.BixVReaderProtocol;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BixVReaderIPCProtocol
implements BixVReaderProtocol {
    RandomAccessFile dataPipe = null;
    RandomAccessFile eventsPipe = null;

    public void connect(int readerIdx) throws FileNotFoundException {
        this.dataPipe = new RandomAccessFile("\\\\.\\pipe\\SCardSimulatorDriver" + readerIdx, "rws");
        this.eventsPipe = new RandomAccessFile("\\\\.\\pipe\\SCardSimulatorDriverEvents" + readerIdx, "rws");
    }

    @Override
    public void disconnect() {
        this.closePipe(this.dataPipe);
        this.closePipe(this.eventsPipe);
    }

    @Override
    public int readCommand() throws IOException {
        byte[] cmdBuf = new byte[4];
        this.dataPipe.readFully(cmdBuf);
        int cmd = this.cmdFromBytes(cmdBuf);
        return cmd;
    }

    @Override
    public void writeDataCommand(int cmd) throws IOException {
        this.writeCommand(this.dataPipe, cmd);
    }

    @Override
    public void writeEventCommand(int cmd) throws IOException {
        this.writeCommand(this.eventsPipe, cmd);
    }

    @Override
    public byte[] readData() throws IOException {
        int dataLen = this.readCommand();
        byte[] dataBuf = new byte[dataLen];
        this.dataPipe.readFully(dataBuf);
        return dataBuf;
    }

    @Override
    public void writeData(byte[] data) throws IOException {
        byte[] dataBuf = new byte[4 + data.length];
        byte[] dataLen = this.cmdToBytes(data.length);
        System.arraycopy(dataLen, 0, dataBuf, 0, 4);
        System.arraycopy(data, 0, dataBuf, 4, data.length);
        this.dataPipe.write(dataBuf);
    }

    private byte[] cmdToBytes(int cmd) {
        return new byte[]{(byte)cmd, (byte)(cmd >>> 8), (byte)(cmd >>> 16), (byte)(cmd >>> 24)};
    }

    private int cmdFromBytes(byte[] cmd) {
        return cmd[0] & 0xFF | (cmd[1] & 0xFF) << 8 | (cmd[2] & 0xFF) << 16 | (cmd[3] & 0xFF) << 24;
    }

    private void writeCommand(RandomAccessFile pipe, int cmd) throws IOException {
        pipe.write(this.cmdToBytes(cmd));
    }

    private void closePipe(RandomAccessFile pipe) {
        try {
            pipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

